/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html;

import fitnesse.html.HtmlComment;
import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.RawHtml;
import fitnesse.html.TagGroup;
import fitnesse.wiki.PageCrawlerImpl;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public class HtmlUtil {
    public static HtmlElement BR = new RawHtml("<br/>");
    public static HtmlElement HR = new RawHtml("<hr/>");
    public static HtmlElement NBSP = new RawHtml("&nbsp;");
    public static HtmlElement P = new RawHtml("<p>");
    public static final boolean NO_NEW_WINDOW = false;
    public static final String ENDL = System.getProperty("line.separator");

    public static HtmlTag makeDivTag(String string) {
        HtmlTag htmlTag = new HtmlTag("div");
        htmlTag.addAttribute("class", string);
        htmlTag.add("");
        return htmlTag;
    }

    public static void addTitles(HtmlPage htmlPage, String string) {
        htmlPage.title.use(string);
        HtmlTag htmlTag = new HtmlTag("span");
        htmlTag.addAttribute("class", "page_title");
        htmlTag.add(string);
        htmlPage.header.use(htmlTag);
    }

    public static HtmlTag makeBold(String string) {
        HtmlTag htmlTag = new HtmlTag("b");
        htmlTag.add(string);
        return htmlTag;
    }

    public static HtmlTag makeItalic(String string) {
        HtmlTag htmlTag = new HtmlTag("i");
        htmlTag.add(string);
        return htmlTag;
    }

    public static HtmlTag makeSpanTag(String string, String string2) {
        HtmlTag htmlTag = new HtmlTag("span");
        htmlTag.addAttribute("class", string);
        htmlTag.add(string2);
        return htmlTag;
    }

    public static HtmlTag makeFormTag(String string, String string2) {
        HtmlTag htmlTag = new HtmlTag("form");
        htmlTag.addAttribute("method", string);
        htmlTag.addAttribute("action", string2);
        return htmlTag;
    }

    public static HtmlTag makeAnchorTag(String string) {
        HtmlTag htmlTag = new HtmlTag("a", " ");
        htmlTag.addAttribute("name", string);
        return htmlTag;
    }

    public static HtmlTag makeActionLink(String string, String string2, String string3, String string4, boolean bl) {
        TagGroup tagGroup = new TagGroup();
        String string5 = string;
        if (string3 != null) {
            string5 = string5 + "?" + string3;
        }
        HtmlTag htmlTag = new HtmlTag("a");
        htmlTag.addAttribute("href", string5);
        if (bl) {
            htmlTag.addAttribute("target", "newWindow");
        }
        htmlTag.addAttribute("accesskey", string4);
        htmlTag.add(string2);
        tagGroup.add(new HtmlComment(string2 + " button"));
        tagGroup.add(htmlTag);
        return tagGroup;
    }

    public static HtmlTag makeInputTag(String string, String string2, String string3) {
        HtmlTag htmlTag = HtmlUtil.makeInputTag(string, string2);
        htmlTag.addAttribute("value", string3);
        return htmlTag;
    }

    public static HtmlTag makeInputTag(String string, String string2) {
        HtmlTag htmlTag = new HtmlTag("input");
        htmlTag.addAttribute("type", string);
        htmlTag.addAttribute("name", string2);
        return htmlTag;
    }

    public static HtmlTag makeOptionTag(String string, String string2) {
        HtmlTag htmlTag = new HtmlTag("option");
        htmlTag.addAttribute("value", string);
        htmlTag.add(string2);
        return htmlTag;
    }

    public static HtmlTag makeLink(String string, String string2) {
        return HtmlUtil.makeLink(string, new RawHtml(string2));
    }

    public static HtmlTag makeLink(String string, HtmlElement htmlElement) {
        HtmlTag htmlTag = new HtmlTag("a");
        htmlTag.addAttribute("href", string);
        htmlTag.add(htmlElement);
        return htmlTag;
    }

    public static TagGroup makeBreadCrumbsWithCurrentPageLinked(String string) throws Exception {
        return HtmlUtil.makeBreadCrumbsWithCurrentPageLinked(string, ".");
    }

    public static HtmlTag makeBreadCrumbsWithCurrentPageNotLinked(String string) throws Exception {
        return HtmlUtil.makeBreadCrumbsWithCurrentPageNotLinked(string, ".");
    }

    public static TagGroup makeBreadCrumbsWithCurrentPageLinked(String string, String string2) throws Exception {
        TagGroup tagGroup = new TagGroup();
        String[] stringArray = string.split("[" + string2 + "]");
        String string3 = HtmlUtil.makeAllButLastCrumb(stringArray, string2, tagGroup);
        tagGroup.add(HtmlUtil.getLastCrumbAsLink(stringArray, string3));
        return tagGroup;
    }

    public static HtmlTag makeBreadCrumbsWithCurrentPageNotLinked(String string, String string2) throws Exception {
        TagGroup tagGroup = new TagGroup();
        String[] stringArray = string.split("[" + string2 + "]");
        HtmlUtil.makeAllButLastCrumb(stringArray, string2, tagGroup);
        tagGroup.add(HtmlUtil.getLastCrumbAsText(stringArray));
        return tagGroup;
    }

    private static HtmlTag getLastCrumbAsLink(String[] stringArray, String string) throws Exception {
        String string2 = HtmlUtil.getLastCrumb(stringArray);
        HtmlTag htmlTag = HtmlUtil.makeLink("/" + string + string2, string2);
        htmlTag.head = BR.html();
        htmlTag.addAttribute("class", "page_title");
        return htmlTag;
    }

    private static String getLastCrumb(String[] stringArray) {
        String string = "";
        if (stringArray.length > 0) {
            string = stringArray[stringArray.length - 1];
        }
        return string;
    }

    private static HtmlTag getLastCrumbAsText(String[] stringArray) throws Exception {
        String string = HtmlUtil.getLastCrumb(stringArray);
        HtmlTag htmlTag = new HtmlTag("span", string);
        htmlTag.addAttribute("class", "page_title");
        htmlTag.head = BR.html();
        return htmlTag;
    }

    public static HtmlTag makeBreadCrumbsWithPageType(String string, String string2) throws Exception {
        return HtmlUtil.makeBreadCrumbsWithPageType(string, ".", string2);
    }

    public static HtmlTag makeBreadCrumbsWithPageType(String string, String string2, String string3) throws Exception {
        TagGroup tagGroup = HtmlUtil.makeBreadCrumbsWithCurrentPageLinked(string, string2);
        tagGroup.add(BR);
        tagGroup.add(HtmlUtil.makeSpanTag("page_type", string3));
        return tagGroup;
    }

    private static String makeAllButLastCrumb(String[] stringArray, String string, TagGroup tagGroup) {
        String string2 = "";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            String string3 = stringArray[i];
            HtmlTag htmlTag = HtmlUtil.makeLink("/" + string2 + string3, string3);
            htmlTag.tail = string;
            string2 = string2 + string3 + string;
            tagGroup.add(htmlTag);
        }
        return string2;
    }

    public static HtmlTag makeActions(PageData pageData) throws Exception {
        String string;
        WikiPage wikiPage = pageData.getWikiPage();
        WikiPagePath wikiPagePath = wikiPage.getPageCrawler().getFullPath(wikiPage);
        String string2 = string = PathParser.render(wikiPagePath);
        boolean bl = false;
        if (wikiPage instanceof ProxyPage) {
            ProxyPage proxyPage = (ProxyPage)wikiPage;
            string2 = proxyPage.getThisPageUrl();
            bl = true;
        }
        return HtmlUtil.makeActions(pageData, string, string2, bl);
    }

    public static HtmlTag makeActions(PageData pageData, String string, String string2, boolean bl) throws Exception {
        TagGroup tagGroup = new TagGroup();
        if (pageData.hasAttribute("Test")) {
            tagGroup.add(HtmlUtil.makeActionLink(string, "Test", "test", "t", false));
        }
        if (pageData.hasAttribute("Suite")) {
            tagGroup.add(HtmlUtil.makeActionLink(string, "Suite", "suite", "", false));
        }
        if (pageData.hasAttribute("Test") || pageData.hasAttribute("Suite")) {
            tagGroup.add(HtmlUtil.makeNavBreak());
        }
        if (pageData.hasAttribute("Edit")) {
            tagGroup.add(HtmlUtil.makeActionLink(string2, "Edit", "edit", "e", bl));
        }
        if (pageData.hasAttribute("Versions")) {
            tagGroup.add(HtmlUtil.makeActionLink(string2, "Versions", "versions", "v", bl));
        }
        if (pageData.hasAttribute("Properties")) {
            tagGroup.add(HtmlUtil.makeActionLink(string2, "Properties", "properties", "p", bl));
        }
        if (pageData.hasAttribute("Refactor")) {
            tagGroup.add(HtmlUtil.makeActionLink(string2, "Refactor", "refactor", "r", bl));
        }
        if (pageData.hasAttribute("WhereUsed")) {
            tagGroup.add(HtmlUtil.makeActionLink(string2, "Where Used", "whereUsed", "w", false));
        }
        tagGroup.add(HtmlUtil.makeNavBreak());
        if (pageData.hasAttribute("RecentChanges")) {
            tagGroup.add(HtmlUtil.makeActionLink("/RecentChanges", "RecentChanges", null, "", false));
        }
        if (pageData.hasAttribute("Files")) {
            tagGroup.add(HtmlUtil.makeActionLink("/files", "Files", null, "f", false));
        }
        if (pageData.hasAttribute("Search")) {
            tagGroup.add(HtmlUtil.makeActionLink("?searchForm", "Search", null, "s", false));
        }
        return tagGroup;
    }

    public static HtmlTag makeNavBreak() {
        HtmlTag htmlTag = new HtmlTag("div");
        htmlTag.addAttribute("class", "nav_break");
        htmlTag.add("&nbsp;");
        return htmlTag;
    }

    public static String makeNormalWikiPageContent(PageData pageData) throws Exception {
        String string = HtmlUtil.testableHtml(pageData);
        return HtmlUtil.addHeaderAndFooter(pageData.getWikiPage(), string);
    }

    public static String addHeaderAndFooter(WikiPage wikiPage, String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HtmlUtil.getHtmlOfInheritedPage("PageHeader", wikiPage));
        stringBuffer.append(string);
        stringBuffer.append(HtmlUtil.getHtmlOfInheritedPage("PageFooter", wikiPage));
        return stringBuffer.toString();
    }

    public static String testableHtml(PageData pageData) throws Exception {
        String string;
        WikiPagePath wikiPagePath;
        WikiPage wikiPage;
        WikiPage wikiPage2 = pageData.getWikiPage();
        StringBuffer stringBuffer = new StringBuffer();
        if (pageData.hasAttribute("Test") && (wikiPage = PageCrawlerImpl.getInheritedPage("SetUp", wikiPage2)) != null) {
            wikiPagePath = wikiPage2.getPageCrawler().getFullPath(wikiPage);
            string = PathParser.render(wikiPagePath);
            stringBuffer.append("!include -setup .").append(string).append("\n");
        }
        stringBuffer.append(pageData.getContent());
        if (pageData.hasAttribute("Test") && (wikiPage = PageCrawlerImpl.getInheritedPage("TearDown", wikiPage2)) != null) {
            wikiPagePath = wikiPage2.getPageCrawler().getFullPath(wikiPage);
            string = PathParser.render(wikiPagePath);
            stringBuffer.append("\n").append("!include -teardown .").append(string).append("\n");
        }
        pageData.setContent(stringBuffer.toString());
        return pageData.getHtml();
    }

    public static String getHtmlOfInheritedPage(String string, WikiPage wikiPage) throws Exception {
        return HtmlUtil.getLabeledHtmlOfInheritedPage(string, wikiPage, "");
    }

    public static String getLabeledHtmlOfInheritedPage(String string, WikiPage wikiPage, String string2) throws Exception {
        WikiPage wikiPage2 = PageCrawlerImpl.getInheritedPage(string, wikiPage);
        if (wikiPage2 != null) {
            PageData pageData = wikiPage2.getData();
            if (string2 != null && string2.length() > 1) {
                WikiPagePath wikiPagePath = wikiPage.getPageCrawler().getFullPath(wikiPage2);
                String string3 = PathParser.render(wikiPagePath);
                String string4 = "!meta " + string2 + ": ." + string3 + "\n";
                String string5 = string4 + pageData.getContent();
                pageData.setContent(string5);
            }
            return pageData.getHtml(wikiPage);
        }
        return "";
    }

    public static String metaText(String string) {
        return "<span class=\"meta\">" + string + "</span>";
    }

    public static HtmlTag makeJavascriptLink(String string) {
        HtmlTag htmlTag = new HtmlTag("script");
        htmlTag.addAttribute("src", string);
        htmlTag.addAttribute("type", "text/javascript");
        htmlTag.use("");
        return htmlTag;
    }
}

