/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html;

import fitnesse.html.HtmlElement;
import fitnesse.html.RawHtml;
import java.util.LinkedList;
import java.util.List;

public class HtmlTag
extends HtmlElement {
    public LinkedList childTags = new LinkedList();
    protected List attributes = new LinkedList();
    protected String tagName = "youreIt";
    public String tail;
    public String head;

    public HtmlTag(String string) {
        this.tagName = string;
    }

    public HtmlTag(String string, String string2) {
        this(string);
        this.add(string2);
    }

    public HtmlTag(String string, HtmlElement htmlElement) {
        this(string);
        this.add(htmlElement);
    }

    public String tagName() {
        return this.tagName;
    }

    public String html() throws Exception {
        return this.html(0);
    }

    public String html(int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        this.addTabs(n, stringBuffer);
        if (this.head != null) {
            stringBuffer.append(this.head);
        }
        stringBuffer.append("<").append(this.tagName());
        this.addAttributes(stringBuffer);
        if (this.hasChildren()) {
            stringBuffer.append(">");
            boolean bl = this.addChildHtml(stringBuffer, n);
            if (bl) {
                this.addTabs(n, stringBuffer);
            }
            stringBuffer.append("</").append(this.tagName()).append(">");
        } else {
            stringBuffer.append("/>");
        }
        if (this.tail != null) {
            stringBuffer.append(this.tail);
        }
        stringBuffer.append(endl);
        return stringBuffer.toString();
    }

    private void addAttributes(StringBuffer stringBuffer) {
        for (Attribute attribute : this.attributes) {
            stringBuffer.append(" ").append(attribute.name).append("=\"").append(attribute.value).append("\"");
        }
    }

    protected void addTabs(int n, StringBuffer stringBuffer) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('\t');
        }
    }

    private boolean addChildHtml(StringBuffer stringBuffer, int n) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        for (HtmlElement htmlElement : this.childTags) {
            if (htmlElement instanceof HtmlTag) {
                if (n2 == 0 || bl2) {
                    stringBuffer.append(endl);
                }
                stringBuffer.append(((HtmlTag)htmlElement).html(n + 1));
                bl = true;
                bl2 = false;
            } else {
                stringBuffer.append(htmlElement.html());
                bl2 = true;
            }
            ++n2;
        }
        return bl;
    }

    private boolean hasChildren() {
        return this.childTags.size() > 0;
    }

    public void add(String string) {
        this.add(new RawHtml(string));
    }

    public void add(HtmlElement htmlElement) {
        this.childTags.add(htmlElement);
    }

    public void addAttribute(String string, String string2) {
        this.attributes.add(new Attribute(string, string2));
    }

    public void use(String string) {
        this.use(new RawHtml(string));
    }

    public void use(HtmlElement htmlElement) {
        this.childTags.clear();
        this.add(htmlElement);
    }

    public String getAttribute(String string) {
        for (Attribute attribute : this.attributes) {
            if (string == null || !string.equals(attribute.name)) continue;
            return attribute.value;
        }
        return null;
    }

    public static class Attribute {
        public String name;
        public String value;

        public Attribute(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

