/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html;

import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;

public class HtmlPage
extends HtmlTag {
    public static final String DTD = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.DTD\">";
    public static final String BreakPoint = "<!--BREAKPOINT-->";
    public HtmlTag head;
    public HtmlTag title;
    public HtmlTag body;
    public HtmlTag header;
    public HtmlTag sidebar;
    public HtmlTag mainbar;
    public HtmlTag artNiche;
    public HtmlTag actions;
    public HtmlTag main;
    public String preDivision;
    public String postDivision;

    protected HtmlPage() {
        super("html");
        this.add(this.makeHead());
        this.add(this.makeBody());
    }

    public String html() throws Exception {
        String string = DTD + endl + super.html();
        return string;
    }

    protected HtmlTag makeBody() {
        this.body = new HtmlTag("body");
        this.mainbar = HtmlUtil.makeDivTag("mainbar");
        this.header = HtmlUtil.makeDivTag("header");
        this.sidebar = HtmlUtil.makeDivTag("sidebar");
        this.actions = HtmlUtil.makeDivTag("actions");
        this.main = HtmlUtil.makeDivTag("main");
        this.makeArtNiche();
        this.mainbar.add(this.header);
        this.mainbar.add(this.main);
        this.sidebar.add(this.artNiche);
        this.sidebar.add(this.actions);
        this.body.add(this.sidebar);
        this.body.add(this.mainbar);
        return this.body;
    }

    protected void makeArtNiche() {
        this.artNiche = HtmlUtil.makeDivTag("art_niche");
        this.artNiche.addAttribute("onclick", "document.location='/'");
    }

    protected HtmlTag makeHead() {
        this.head = new HtmlTag("head");
        this.title = new HtmlTag("title");
        this.title.add("FitNesse");
        this.head.add(this.title);
        this.head.add(this.makeCssLink("/files/css/fitnesse.css", "screen"));
        this.head.add(this.makeCssLink("/files/css/fitnesse_print.css", "print"));
        this.head.add(HtmlUtil.makeJavascriptLink("/files/javascript/fitnesse.js"));
        return this.head;
    }

    public HtmlTag makeCssLink(String string, String string2) {
        HtmlTag htmlTag = new HtmlTag("link");
        htmlTag.addAttribute("rel", "stylesheet");
        htmlTag.addAttribute("type", "text/css");
        htmlTag.addAttribute("href", string);
        htmlTag.addAttribute("media", string2);
        return htmlTag;
    }

    public void divide() throws Exception {
        String string = this.html();
        int n = string.indexOf(BreakPoint);
        this.preDivision = string.substring(0, n);
        this.postDivision = string.substring(n + BreakPoint.length());
    }
}

