/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fit.Fixture;
import fit.Parse;
import fit.exception.FitFailureException;

public abstract class TableFixture
extends Fixture {
    protected Parse firstRow;

    public void doRows(Parse parse) {
        this.firstRow = parse;
        if (parse == null) {
            throw new FitFailureException("There are no rows in this table");
        }
        this.doStaticTable(parse.size());
    }

    protected abstract void doStaticTable(int var1);

    protected Parse getCell(int n, int n2) {
        return this.firstRow.at(n, n2);
    }

    protected String getText(int n, int n2) {
        return this.getCell(n, n2).text();
    }

    protected boolean blank(int n, int n2) {
        return this.getText(n, n2).equals("");
    }

    protected void wrong(int n, int n2) {
        this.wrong(this.getCell(n, n2));
    }

    protected void right(int n, int n2) {
        this.right(this.getCell(n, n2));
    }

    protected void wrong(int n, int n2, String string) {
        this.wrong(this.getCell(n, n2), string);
    }

    protected void ignore(int n, int n2) {
        this.ignore(this.getCell(n, n2));
    }

    protected int getInt(int n, int n2) {
        int n3 = 0;
        String string = this.getText(n, n2);
        if (string.equals("")) {
            this.ignore(n, n2);
            return 0;
        }
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.wrong(n, n2);
        }
        return n3;
    }
}

