/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fit.ColumnFixture;
import fit.Parse;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class RowEntryFixture
extends ColumnFixture {
    public static final String ERROR_INDICATOR = "Unable to enter last row: ";
    public static final String RIGHT_STYLE = "pass";
    public static final String WRONG_STYLE = "fail";

    public abstract void enterRow() throws Exception;

    public void doRow(Parse parse) {
        if (parse.parts.body.indexOf(ERROR_INDICATOR) != -1) {
            return;
        }
        super.doRow(parse);
        try {
            this.enterRow();
            this.right(this.appendCell(parse, "entered"));
        }
        catch (Exception exception) {
            this.wrong(this.appendCell(parse, "skipped"));
            this.reportError(parse, exception);
        }
    }

    protected Parse appendCell(Parse parse, String string) {
        Parse parse2;
        parse.parts.last().more = parse2 = new Parse("td", string, null, null);
        return parse2;
    }

    public void reportError(Parse parse, Exception exception) {
        Parse parse2 = this.makeMessageCell(exception);
        this.insertRowAfter(parse, new Parse("tr", null, parse2, null));
    }

    public Parse makeMessageCell(Exception exception) {
        Parse parse = new Parse("td", "", null, null);
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        parse.addToTag(" colspan=\"" + (this.columnBindings.length + 1) + "\"");
        parse.addToBody("<i>Unable to enter last row: " + exception.getMessage() + "</i>");
        parse.addToBody("<pre>" + stringWriter.toString() + "</pre>");
        this.wrong(parse);
        return parse;
    }

    public void insertRowAfter(Parse parse, Parse parse2) {
        Parse parse3 = parse.more;
        parse.more = parse2;
        parse2.more = parse3;
    }
}

