/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fit.ColumnFixture;
import fitnesse.fixtures.FitnesseFixtureContext;
import fitnesse.wikitext.Utils;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResponseExaminer
extends ColumnFixture {
    public String type;
    public String pattern;
    public String value;
    public int number;
    private Matcher matcher;
    private int currentLine = 0;

    public String contents() throws Exception {
        return Utils.escapeText(FitnesseFixtureContext.sender.sentData());
    }

    public String fullContents() throws Exception {
        return Utils.escapeText(FitnesseFixtureContext.sender.sentData());
    }

    public boolean inOrder() throws Exception {
        if (this.value == null) {
            return false;
        }
        String string = FitnesseFixtureContext.sender.sentData();
        String[] stringArray = this.arrayifyLines(string);
        for (int i = this.currentLine; i < stringArray.length; ++i) {
            if (!this.value.equals(stringArray[i].trim())) continue;
            this.currentLine = i;
            return true;
        }
        return false;
    }

    public int matchCount() throws Exception {
        Pattern pattern = Pattern.compile(Utils.escapeText(this.pattern), 40);
        this.value = null;
        if (this.type.equals("contents")) {
            this.value = this.contents();
        } else if (this.type.equals("fullContents")) {
            this.value = this.fullContents();
        } else if (this.type.equals("status")) {
            this.value = "" + FitnesseFixtureContext.response.getStatus();
        } else if (this.type.equals("headers")) {
            String string = FitnesseFixtureContext.sender.sentData();
            int n = string.indexOf("\r\n\r\n");
            this.value = string.substring(0, n + 2);
        }
        this.matcher = pattern.matcher(this.value);
        int n = 0;
        n = 0;
        while (this.matcher.find()) {
            ++n;
        }
        return n;
    }

    public boolean matches() throws Exception {
        return this.matchCount() > 0;
    }

    public String string() throws Exception {
        String string = null;
        if (this.type.equals("contents")) {
            return FitnesseFixtureContext.page.getData().getHtml();
        }
        if (this.type.equals("line")) {
            String string2 = FitnesseFixtureContext.page.getData().getHtml();
            String string3 = this.convertBreaksToLineSeparators(string2);
            StringTokenizer stringTokenizer = this.tokenizeLines(string3);
            for (int i = this.number; i != 0; --i) {
                string = stringTokenizer.nextToken();
            }
            return string.trim();
        }
        throw new Exception("Bad type in ResponseExaminer");
    }

    private StringTokenizer tokenizeLines(String string) {
        return new StringTokenizer(string, System.getProperty("line.separator"));
    }

    private String[] arrayifyLines(String string) {
        return string.split(System.getProperty("line.separator"));
    }

    private String convertBreaksToLineSeparators(String string) {
        String string2 = string.replaceAll("<br>", System.getProperty("line.separator"));
        return string2;
    }

    public String found() {
        return this.matcher.group(0);
    }

    public String source() {
        return this.value;
    }
}

