/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fit.Fixture;
import fitnesse.fixtures.FitnesseFixtureContext;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;

public class PageBuilder
extends Fixture {
    private PrintWriter writer;
    private StringWriter stringWriter = new StringWriter();
    private String pageAttributes = null;

    public PageBuilder() {
        this.writer = new PrintWriter(this.stringWriter);
    }

    public void line(String string) {
        if (string.startsWith("\\")) {
            string = string.substring(1);
        }
        this.writer.println(string);
    }

    public void page(String string) throws Exception {
        String string2 = this.stringWriter.toString();
        PageCrawler pageCrawler = FitnesseFixtureContext.root.getPageCrawler();
        WikiPagePath wikiPagePath = PathParser.parse(string);
        WikiPage wikiPage = pageCrawler.addPage(FitnesseFixtureContext.root, wikiPagePath, string2);
        if (this.pageAttributes != null) {
            PageData pageData = wikiPage.getData();
            this.setAttributes(pageData);
            wikiPage.commit(pageData);
            this.pageAttributes = null;
        }
    }

    public void attributes(String string) {
        this.pageAttributes = string;
    }

    private void setAttributes(PageData pageData) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(this.pageAttributes, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            int n = string.indexOf("=");
            if (n < 0) {
                throw new Exception("Attribute must have form name=value");
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            pageData.setAttribute(string2, string3);
        }
    }
}

