/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlWriter {
    private static String endl = System.getProperty("line.separator");
    private Writer writer;
    private boolean isNewLine;

    public XmlWriter(OutputStream outputStream) throws Exception {
        this.writer = new OutputStreamWriter(outputStream, "UTF-8");
    }

    public void write(Document document) throws Exception {
        this.write("<?xml version=\"1.0\"?>");
        this.write(endl);
        this.write(document.getDocumentElement(), 0);
    }

    public void write(NodeList nodeList) throws Exception {
        this.write(nodeList, 0);
    }

    public void write(Element element, int n) throws Exception {
        if (!this.isNewLine) {
            this.write(endl);
        }
        if (!element.hasChildNodes()) {
            this.writeTabs(n);
            this.write("<" + element.getTagName() + this.writeAttributes(element) + "/>");
        } else {
            this.writeTabs(n);
            this.write("<" + element.getTagName() + this.writeAttributes(element) + ">");
            this.write(element.getChildNodes(), n + 1);
            if (this.isNewLine) {
                this.writeTabs(n);
            }
            this.write("</" + element.getTagName() + ">");
        }
        this.write(endl);
    }

    private String writeAttributes(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getName();
            String string2 = attr.getValue();
            stringBuffer.append(" ").append(string).append("=\"").append(string2).append("\"");
        }
        return stringBuffer.toString();
    }

    private void write(NodeList nodeList, int n) throws Exception {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            this.write(node, n);
        }
    }

    private void writeText(Text text) throws Exception {
        String string = text.getNodeValue();
        this.write(string.trim());
    }

    private void writeCdata(CDATASection cDATASection) throws Exception {
        String string = "<![CDATA[" + cDATASection.getNodeValue() + "]]>";
        this.write(string);
    }

    private void write(Node node, int n) throws Exception {
        if (node instanceof Element) {
            this.write((Element)node, n);
        } else if (node instanceof CDATASection) {
            this.writeCdata((CDATASection)node);
        } else if (node instanceof Text) {
            this.writeText((Text)node);
        } else {
            throw new Exception("XmlWriter: unsupported node type: " + node.getClass());
        }
    }

    private void writeTabs(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.write("\t");
        }
    }

    private void write(String string) throws Exception {
        if (string == null || "".equals(string)) {
            return;
        }
        this.isNewLine = endl.equals(string);
        this.writer.write(string);
    }

    public void flush() throws Exception {
        this.writer.flush();
    }

    public void close() throws Exception {
        this.writer.close();
    }
}

