/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.FitNesseTraversalListener;
import fitnesse.components.SearchObserver;
import fitnesse.wiki.WikiPage;

public class Searcher
implements FitNesseTraversalListener {
    WikiPage root;
    SearchObserver observer;
    boolean isTitleSearch = false;
    private String searchString;

    public Searcher(String string, WikiPage wikiPage) throws Exception {
        this.searchString = string.toLowerCase();
        this.root = wikiPage;
    }

    public void searchContent(SearchObserver searchObserver) throws Exception {
        this.search(searchObserver);
    }

    private void search(SearchObserver searchObserver) throws Exception {
        this.observer = searchObserver;
        this.processPage(this.root);
        this.root.getPageCrawler().traverse(this.root, this);
    }

    public void processPage(WikiPage wikiPage) throws Exception {
        if (this.isHit(wikiPage)) {
            this.observer.hit(wikiPage);
        }
    }

    private boolean isHit(WikiPage wikiPage) throws Exception {
        String string = wikiPage.getName().toLowerCase();
        if (!this.isTitleSearch) {
            string = wikiPage.getData().getContent().toLowerCase();
        }
        boolean bl = string.indexOf(this.searchString) != -1;
        return bl;
    }

    public String getSearchPattern() throws Exception {
        return this.searchString;
    }

    public void searchTitles(SearchObserver searchObserver) throws Exception {
        this.isTitleSearch = true;
        this.search(searchObserver);
    }
}

