/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.FitNesseContext;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.BufferedReader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;

public class RecentChanges {
    private static final String RECENT_CHANGES = "RecentChanges";

    private static SimpleDateFormat makeDateFormat() {
        return new SimpleDateFormat(FitNesseContext.recentChangesDateFormat);
    }

    public static void updateRecentChanges(PageData pageData) throws Exception {
        RecentChanges.createRecentChangesIfNecessary(pageData);
        RecentChanges.addCurrentPageToRecentChanges(pageData);
    }

    public static List getRecentChangesLines(PageData pageData) throws Exception {
        String string = pageData.getContent();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static void addCurrentPageToRecentChanges(PageData pageData) throws Exception {
        WikiPage wikiPage = pageData.getWikiPage().getPageCrawler().getRoot(pageData.getWikiPage()).getChildPage(RECENT_CHANGES);
        String string = RecentChanges.resource(pageData);
        PageData pageData2 = wikiPage.getData();
        List list = RecentChanges.getRecentChangesLines(pageData2);
        RecentChanges.removeDuplicate(list, string);
        list.add(0, RecentChanges.makeRecentChangesLine(pageData));
        RecentChanges.trimExtraLines(list);
        String string2 = RecentChanges.convertLinesToWikiText(list);
        pageData2.setContent(string2);
        wikiPage.commit(pageData2);
    }

    private static String resource(PageData pageData) throws Exception {
        WikiPagePath wikiPagePath = pageData.getWikiPage().getPageCrawler().getFullPath(pageData.getWikiPage());
        String string = PathParser.render(wikiPagePath);
        return string;
    }

    private static void createRecentChangesIfNecessary(PageData pageData) throws Exception {
        PageCrawler pageCrawler = pageData.getWikiPage().getPageCrawler();
        WikiPage wikiPage = pageCrawler.getRoot(pageData.getWikiPage());
        if (!wikiPage.hasChildPage(RECENT_CHANGES)) {
            pageCrawler.addPage(wikiPage, PathParser.parse(RECENT_CHANGES), "");
        }
    }

    private static String makeRecentChangesLine(PageData pageData) throws Exception {
        String string = pageData.getAttribute("LastModifyingUser");
        if (string == null) {
            string = "";
        }
        return "|" + RecentChanges.resource(pageData) + "|" + string + "|" + RecentChanges.makeDateFormat().format(new Date()) + "|";
    }

    private static void removeDuplicate(List list, String string) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            if (!string2.startsWith("|" + string + "|")) continue;
            listIterator.remove();
        }
    }

    private static String convertLinesToWikiText(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    private static void trimExtraLines(List list) {
        while (list.size() > 100) {
            list.remove(100);
        }
    }
}

