/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.LogData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class Logger {
    private File directory;
    private PrintWriter writer;
    private GregorianCalendar currentFileCreationDate;

    public static SimpleDateFormat makeLogFormat() {
        return new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
    }

    public static SimpleDateFormat makeFileNameFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss");
    }

    public Logger(String string) {
        this.directory = new File(string);
        this.directory.mkdir();
    }

    public File getDirectory() {
        return this.directory;
    }

    String formatLogLine(LogData logData) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(logData.host).append(" - ");
        stringBuffer.append(logData.username == null ? "-" : logData.username);
        stringBuffer.append(" [").append(Logger.format(Logger.makeLogFormat(), logData.time)).append("] ");
        stringBuffer.append('\"').append(logData.requestLine).append("\" ");
        stringBuffer.append(logData.status).append(" ");
        stringBuffer.append(logData.size);
        return stringBuffer.toString();
    }

    static String makeLogFileName(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("fitnesse").append(Logger.format(Logger.makeFileNameFormat(), calendar)).append(".log");
        return stringBuffer.toString();
    }

    public void log(LogData logData) throws Exception {
        if (this.needNewFile(logData.time)) {
            this.openNewFile(logData);
        }
        this.writer.println(this.formatLogLine(logData));
        this.writer.flush();
    }

    private boolean needNewFile(GregorianCalendar gregorianCalendar) {
        if (this.writer == null) {
            return true;
        }
        boolean bl = gregorianCalendar.get(6) != this.currentFileCreationDate.get(6) || gregorianCalendar.get(1) != this.currentFileCreationDate.get(1);
        return bl;
    }

    private void openNewFile(LogData logData) throws FileNotFoundException {
        if (this.writer != null) {
            this.writer.close();
        }
        this.currentFileCreationDate = logData.time;
        String string = Logger.makeLogFileName(logData.time);
        File file = new File(this.directory, string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.writer = new PrintWriter(fileOutputStream);
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private static String format(DateFormat dateFormat, Calendar calendar) {
        DateFormat dateFormat2 = (DateFormat)dateFormat.clone();
        dateFormat2.setTimeZone(calendar.getTimeZone());
        return dateFormat2.format(calendar.getTime());
    }

    public String toString() {
        return this.getDirectory().getAbsolutePath();
    }
}

