/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fit.Counts;
import fitnesse.util.StreamReader;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;

public class FitProtocol {
    public static final DecimalFormat format = new DecimalFormat("0000000000");

    public static void writeData(String string, OutputStream outputStream) throws Exception {
        byte[] byArray = string.getBytes("UTF-8");
        FitProtocol.writeData(byArray, outputStream);
    }

    public static void writeData(byte[] byArray, OutputStream outputStream) throws IOException {
        int n = byArray.length;
        FitProtocol.writeSize(n, outputStream);
        outputStream.write(byArray);
        outputStream.flush();
    }

    public static void writeSize(int n, OutputStream outputStream) throws IOException {
        String string = format.format(n);
        byte[] byArray = string.getBytes();
        outputStream.write(byArray);
        outputStream.flush();
    }

    public static void writeCounts(Counts counts, OutputStream outputStream) throws IOException {
        FitProtocol.writeSize(0, outputStream);
        FitProtocol.writeSize(counts.right, outputStream);
        FitProtocol.writeSize(counts.wrong, outputStream);
        FitProtocol.writeSize(counts.ignores, outputStream);
        FitProtocol.writeSize(counts.exceptions, outputStream);
    }

    public static int readSize(StreamReader streamReader) throws Exception {
        String string = streamReader.read(10);
        if (string.length() < 10) {
            throw new Exception("A size value could not be read. Fragment=|" + string + "|");
        }
        return format.parse(string).intValue();
    }

    public static String readDocument(StreamReader streamReader, int n) throws Exception {
        return streamReader.read(n);
    }

    public static Counts readCounts(StreamReader streamReader) throws Exception {
        Counts counts = new Counts();
        counts.right = FitProtocol.readSize(streamReader);
        counts.wrong = FitProtocol.readSize(streamReader);
        counts.ignores = FitProtocol.readSize(streamReader);
        counts.exceptions = FitProtocol.readSize(streamReader);
        return counts;
    }
}

