/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fit.Counts;
import fitnesse.components.FitClientListener;
import fitnesse.components.FitProtocol;
import fitnesse.util.StreamReader;
import java.io.OutputStream;
import java.net.Socket;

public class FitClient {
    protected FitClientListener listener;
    protected Socket fitSocket;
    private OutputStream fitInput;
    private StreamReader fitOutput;
    private volatile int sent = 0;
    private volatile int received = 0;
    private volatile boolean isDoneSending = false;
    protected volatile boolean killed = false;
    protected Thread fitListeningThread;

    public FitClient(FitClientListener fitClientListener) throws Exception {
        this.listener = fitClientListener;
    }

    public void acceptSocket(Socket socket) throws Exception {
        this.checkForPulse();
        this.fitSocket = socket;
        this.fitInput = this.fitSocket.getOutputStream();
        FitProtocol.writeData("", this.fitInput);
        this.fitOutput = new StreamReader(this.fitSocket.getInputStream());
        this.fitListeningThread = new Thread((Runnable)new FitListeningRunnable(), "FitClient fitOutput");
        this.fitListeningThread.start();
    }

    public void send(String string) throws Exception {
        this.checkForPulse();
        FitProtocol.writeData(string, this.fitInput);
        ++this.sent;
    }

    public void done() throws Exception {
        this.checkForPulse();
        FitProtocol.writeSize(0, this.fitInput);
        this.isDoneSending = true;
    }

    public void join() throws Exception {
        if (this.fitListeningThread != null) {
            this.fitListeningThread.join();
        }
    }

    public void kill() throws Exception {
        this.killed = true;
        if (this.fitListeningThread != null) {
            this.fitListeningThread.interrupt();
        }
    }

    public void exceptionOccurred(Exception exception) {
        this.listener.exceptionOccurred(exception);
    }

    protected void checkForPulse() throws InterruptedException {
        if (this.killed) {
            throw new InterruptedException("FitClient was killed");
        }
    }

    private void listenToFit() {
        try {
            while (!this.finishedReading()) {
                Object object;
                int n = FitProtocol.readSize(this.fitOutput);
                if (n != 0) {
                    object = this.fitOutput.read(n);
                    if (this.fitOutput.byteCount() < n) {
                        throw new Exception("I was expecting " + n + " bytes but I only got " + this.fitOutput.byteCount());
                    }
                    this.listener.acceptOutput((String)object);
                    continue;
                }
                object = FitProtocol.readCounts(this.fitOutput);
                this.listener.acceptResults((Counts)object);
                ++this.received;
            }
        }
        catch (Exception exception) {
            this.exceptionOccurred(exception);
        }
    }

    private boolean finishedReading() {
        while (this.stateIndeterminate()) {
            this.shortSleep();
        }
        return this.isDoneSending && this.received == this.sent;
    }

    private boolean stateIndeterminate() {
        return this.received == this.sent && !this.isDoneSending;
    }

    private void shortSleep() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private class FitListeningRunnable
    implements Runnable {
        private FitListeningRunnable() {
        }

        public void run() {
            FitClient.this.listenToFit();
        }
    }
}

