/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.CommandRunner;
import fitnesse.components.FitClient;
import fitnesse.components.FitClientListener;
import fitnesse.responders.run.SocketDealer;
import fitnesse.responders.run.SocketDoner;
import fitnesse.responders.run.SocketSeeker;

public class CommandRunningFitClient
extends FitClient
implements SocketSeeker {
    public static int TIMEOUT = 60000;
    private int ticketNumber;
    public CommandRunner commandRunner;
    private SocketDoner donor;
    private boolean connectionEstablished = false;
    private Thread timeoutThread;
    private Thread earlyTerminationThread;

    public CommandRunningFitClient(FitClientListener fitClientListener, String string, int n, SocketDealer socketDealer) throws Exception {
        super(fitClientListener);
        this.ticketNumber = socketDealer.seekingSocket(this);
        this.commandRunner = new CommandRunner(string + " localhost " + n + " " + this.ticketNumber, "");
    }

    public void start() throws Exception {
        try {
            this.commandRunner.start();
            this.timeoutThread = new Thread((Runnable)new TimeoutRunnable(), "FitClient timeout");
            this.timeoutThread.start();
            this.earlyTerminationThread = new Thread((Runnable)new EarlyTerminationRunnable(), "FitClient early termination");
            this.earlyTerminationThread.start();
            this.waitForConnection();
        }
        catch (Exception exception) {
            this.listener.exceptionOccurred(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptSocketFrom(SocketDoner socketDoner) throws Exception {
        this.donor = socketDoner;
        this.acceptSocket(socketDoner.donateSocket());
        this.connectionEstablished = true;
        CommandRunningFitClient commandRunningFitClient = this;
        synchronized (commandRunningFitClient) {
            this.notify();
        }
    }

    void setTicketNumber(int n) {
        this.ticketNumber = n;
    }

    public boolean isSuccessfullyStarted() {
        return this.fitSocket != null;
    }

    private void waitForConnection() throws InterruptedException {
        while (this.fitSocket == null) {
            Thread.sleep(100L);
            this.checkForPulse();
        }
    }

    public void join() throws Exception {
        try {
            this.commandRunner.join();
            super.join();
            if (this.donor != null) {
                this.donor.finishedWithSocket();
            }
            this.killVigilantThreads();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void kill() throws Exception {
        super.kill();
        this.killVigilantThreads();
        this.commandRunner.kill();
    }

    private void killVigilantThreads() {
        if (this.timeoutThread != null) {
            this.timeoutThread.interrupt();
        }
        if (this.earlyTerminationThread != null) {
            this.earlyTerminationThread.interrupt();
        }
    }

    public void exceptionOccurred(Exception exception) {
        this.commandRunner.exceptionOccurred(exception);
        super.exceptionOccurred(exception);
    }

    private class EarlyTerminationRunnable
    implements Runnable {
        private EarlyTerminationRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                CommandRunningFitClient.this.commandRunner.process.waitFor();
                CommandRunningFitClient commandRunningFitClient = CommandRunningFitClient.this;
                synchronized (commandRunningFitClient) {
                    if (!CommandRunningFitClient.this.connectionEstablished) {
                        CommandRunningFitClient.this.notify();
                        CommandRunningFitClient.this.listener.exceptionOccurred(new Exception("FitClient: external process terminated before a connection could be established."));
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class TimeoutRunnable
    implements Runnable {
        long timeSlept = 0L;

        private TimeoutRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.sleep(TIMEOUT);
                CommandRunningFitClient commandRunningFitClient = CommandRunningFitClient.this;
                synchronized (commandRunningFitClient) {
                    if (CommandRunningFitClient.this.fitSocket == null) {
                        CommandRunningFitClient.this.notify();
                        CommandRunningFitClient.this.listener.exceptionOccurred(new Exception("FitClient: communication socket was not received on time."));
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

