/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CommandRunner {
    protected Process process;
    protected String input = "";
    protected List exceptions = new ArrayList();
    protected OutputStream stdin;
    protected InputStream stdout;
    protected InputStream stderr;
    protected StringBuffer outputBuffer = new StringBuffer();
    protected StringBuffer errorBuffer = new StringBuffer();
    protected int exitCode = -1;
    private long startTime;
    private long endTime;
    private String command = "";

    public CommandRunner() {
    }

    public CommandRunner(String string, String string2) {
        this.command = string;
        this.input = string2;
    }

    public void start() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        this.startTime = System.currentTimeMillis();
        this.process = runtime.exec(this.command);
        this.stdin = this.process.getOutputStream();
        this.stdout = this.process.getInputStream();
        this.stderr = this.process.getErrorStream();
        new Thread((Runnable)new OuputReadingRunnable(this.stdout, this.outputBuffer), "CommandRunner stdout").start();
        new Thread((Runnable)new OuputReadingRunnable(this.stderr, this.errorBuffer), "CommandRunner error").start();
        this.sendInput();
    }

    public void run() throws Exception {
        this.start();
        this.join();
    }

    public void join() throws Exception {
        this.process.waitFor();
        this.endTime = System.currentTimeMillis();
        this.exitCode = this.process.exitValue();
    }

    public void kill() throws Exception {
        if (this.process != null) {
            this.process.destroy();
            this.join();
        }
    }

    protected void setCommand(String string) {
        this.command = string;
    }

    public String getCommand() {
        return this.command;
    }

    public String getOutput() {
        return this.outputBuffer.toString();
    }

    public String getError() {
        return this.errorBuffer.toString();
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public boolean hasExceptions() {
        return this.exceptions.size() > 0;
    }

    public boolean wroteToErrorStream() {
        return this.errorBuffer.length() > 0;
    }

    public boolean wroteToOutputStream() {
        return this.outputBuffer.length() > 0;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void exceptionOccurred(Exception exception) {
        this.exceptions.add(exception);
    }

    public long getExecutionTime() {
        return this.endTime - this.startTime;
    }

    protected void sendInput() throws Exception {
        Thread thread = new Thread(){

            public void run() {
                try {
                    CommandRunner.this.stdin.write(CommandRunner.this.input.getBytes("UTF-8"));
                    CommandRunner.this.stdin.flush();
                    CommandRunner.this.stdin.close();
                }
                catch (Exception exception) {
                    CommandRunner.this.exceptionOccurred(exception);
                }
            }
        };
        thread.start();
        thread.join();
    }

    private void readOutput(InputStream inputStream, StringBuffer stringBuffer) {
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
        }
        catch (Exception exception) {
            this.exceptionOccurred(exception);
        }
    }

    private class OuputReadingRunnable
    implements Runnable {
        public InputStream input;
        public StringBuffer buffer;

        public OuputReadingRunnable(InputStream inputStream, StringBuffer stringBuffer) {
            this.input = inputStream;
            this.buffer = stringBuffer;
        }

        public void run() {
            CommandRunner.this.readOutput(this.input, this.buffer);
        }
    }
}

