/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.util.Wildcard;
import fitnesse.wiki.InheritedItemBuilder;
import fitnesse.wiki.WikiPage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassPathBuilder
extends InheritedItemBuilder {
    public String getClasspath(WikiPage wikiPage) throws Exception {
        List list = this.getInheritedPathElements(wikiPage, new HashSet(89));
        String string = this.createClassPathString(list, this.getPathSeparator(wikiPage));
        return string;
    }

    public String getPathSeparator(WikiPage wikiPage) throws Exception {
        String string = wikiPage.getData().getVariable("PATH_SEPARATOR");
        if (string == null) {
            string = (String)System.getProperties().get("path.separator");
        }
        return string;
    }

    public List getInheritedPathElements(WikiPage wikiPage, Set set) throws Exception {
        return this.getInheritedItems(wikiPage, set);
    }

    public String createClassPathString(List list, String string) {
        if (list.isEmpty()) {
            return "defaultPath";
        }
        StringBuffer stringBuffer = new StringBuffer();
        list = this.expandWildcards(list);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : list) {
            if (string2.matches(".*\\s.*") && string2.indexOf("\"") == -1) {
                string2 = "\"" + string2 + "\"";
            }
            if (hashSet.contains(string2)) continue;
            hashSet.add(string2);
            this.addSeparatorIfNecessary(stringBuffer, string);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private List expandWildcards(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            File file = new File(string);
            File file2 = new File(file.getAbsolutePath()).getParentFile();
            if (file.getName().indexOf(42) != -1 && file2.exists()) {
                File[] fileArray = file2.listFiles(new Wildcard(file.getName()));
                for (int i = 0; i < fileArray.length; ++i) {
                    arrayList.add(fileArray[i].getPath());
                }
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private void addSeparatorIfNecessary(StringBuffer stringBuffer, String string) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(string);
        }
    }

    protected List getItemsFromPage(WikiPage wikiPage) throws Exception {
        return wikiPage.getData().getClasspaths();
    }
}

