/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

public class Base64 {
    private static final byte[] base64Alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes();
    private static final byte pad = 61;

    public static String decode(String string) throws Exception {
        return new String(Base64.decode(string.getBytes("UTF-8")));
    }

    public static byte[] decode(byte[] byArray) {
        int n = Base64.getLengthOfDecoding(byArray);
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; i < byArray.length; i += 4) {
            byte by = Base64.getValueFor(byArray[i]);
            byte by2 = Base64.getValueFor(byArray[i + 1]);
            byte by3 = Base64.getValueFor(byArray[i + 2]);
            byte by4 = Base64.getValueFor(byArray[i + 3]);
            byte by5 = (byte)((by << 2) + (by2 >> 4));
            byte by6 = (byte)((by2 << 4) + (by3 >> 2));
            byte by7 = (byte)((by3 << 6) + by4);
            byArray2[n2++] = by5;
            if (by6 != 0) {
                byArray2[n2++] = by6;
            }
            if (by7 == 0) continue;
            byArray2[n2++] = by7;
        }
        return byArray2;
    }

    public static String encode(String string) throws Exception {
        return new String(Base64.encode(string.getBytes()));
    }

    public static byte[] encode(byte[] byArray) {
        int n = byArray.length;
        int n2 = Base64.getLengthOfEncoding(byArray);
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            byte by = byArray[n4++];
            byte by2 = n4 >= n ? (byte)0 : byArray[n4++];
            byte by3 = n4 >= n ? (byte)0 : byArray[n4++];
            byte by4 = Base64.abs((byte)(by >> 2));
            byte by5 = Base64.abs((byte)((by << 4 & 0x3F) + (by2 >> 4)));
            byte by6 = Base64.abs((byte)((by2 << 2 & 0x3F) + (by3 >> 6)));
            byte by7 = Base64.abs((byte)(by3 & 0x3F));
            byArray2[n3++] = base64Alphabet[by4];
            byArray2[n3++] = base64Alphabet[by5];
            byArray2[n3++] = by6 != 0 ? base64Alphabet[by6] : 61;
            if (by7 != 0) {
                byArray2[n3++] = base64Alphabet[by7];
                continue;
            }
            byArray2[n3++] = 61;
        }
        return byArray2;
    }

    private static int getLengthOfDecoding(byte[] byArray) {
        if (byArray.length == 0) {
            return 0;
        }
        int n = (int)((double)byArray.length * 0.75);
        int n2 = byArray.length - 1;
        while (byArray[n2] == 61) {
            --n;
            --n2;
        }
        return n;
    }

    private static int getLengthOfEncoding(byte[] byArray) {
        boolean bl = byArray.length % 3 != 0;
        int n = byArray.length / 3 * 4;
        if (bl) {
            n += 4;
        }
        return n;
    }

    public static byte getValueFor(byte by) {
        if (by == 61) {
            return 0;
        }
        for (int i = 0; i < base64Alphabet.length; ++i) {
            if (base64Alphabet[i] != by) continue;
            return (byte)i;
        }
        return -1;
    }

    private static byte abs(byte by) {
        return (byte)Math.abs(by);
    }
}

