/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.http.Request;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualMockingPageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageUtil;
import java.util.LinkedList;

public abstract class SecurePageOperation
implements SecureOperation {
    protected abstract String getSecurityMode();

    public boolean shouldAuthenticate(FitNesseContext fitNesseContext, Request request) throws Exception {
        WikiPagePath wikiPagePath = PathParser.parse(request.getResource());
        PageCrawler pageCrawler = fitNesseContext.root.getPageCrawler();
        pageCrawler.setDeadEndStrategy(new VirtualMockingPageCrawler());
        WikiPage wikiPage = pageCrawler.getPage(fitNesseContext.root, wikiPagePath);
        if (wikiPage == null) {
            return false;
        }
        LinkedList linkedList = WikiPageUtil.getAncestorsStartingWith(wikiPage);
        for (WikiPage wikiPage2 : linkedList) {
            if (!this.hasSecurityModeAttribute(wikiPage2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSecurityModeAttribute(WikiPage wikiPage) throws Exception {
        PageData pageData = wikiPage.getData();
        boolean bl = pageData.hasAttribute(this.getSecurityMode());
        return bl;
    }
}

