/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.authentication.PasswordCipher;
import fitnesse.authentication.TransparentCipher;
import fitnesse.util.FileUtil;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class PasswordFile {
    private File passwordFile;
    private Map passwordMap = new HashMap();
    private PasswordCipher cipher = new TransparentCipher();

    public PasswordFile(String string) throws Exception {
        this.passwordFile = new File(string);
        this.loadFile();
    }

    public PasswordFile(String string, PasswordCipher passwordCipher) throws Exception {
        this(string);
        this.cipher = passwordCipher;
    }

    public Map getPasswordMap() {
        return this.passwordMap;
    }

    public String getName() {
        return this.passwordFile.getName();
    }

    public PasswordCipher getCipher() {
        return this.cipher;
    }

    public void savePassword(String string, String string2) throws Exception {
        this.passwordMap.put(string, this.cipher.encrypt(string2));
        this.savePasswords();
    }

    private void loadFile() throws Exception {
        LinkedList linkedList = this.getPasswordFileLines();
        this.loadCipher(linkedList);
        this.loadPasswords(linkedList);
    }

    private void loadPasswords(LinkedList linkedList) {
        for (String string : linkedList) {
            if ("".equals(string)) continue;
            String[] stringArray = string.split(":");
            this.passwordMap.put(stringArray[0], stringArray[1]);
        }
    }

    private void loadCipher(LinkedList linkedList) throws Exception {
        String string;
        if (linkedList.size() > 0 && (string = linkedList.getFirst().toString()).startsWith("!")) {
            String string2 = string.substring(1);
            this.instantiateCipher(string2);
            linkedList.removeFirst();
        }
    }

    public PasswordCipher instantiateCipher(String string) throws Exception {
        Class<?> clazz = Class.forName(string);
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        this.cipher = (PasswordCipher)constructor.newInstance(new Object[0]);
        return this.cipher;
    }

    private void savePasswords() throws Exception {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("!" + this.cipher.getClass().getName());
        for (Object k : this.passwordMap.keySet()) {
            Object v = this.passwordMap.get(k);
            linkedList.add(k + ":" + v);
        }
        FileUtil.writeLinesToFile(this.passwordFile, linkedList);
    }

    private LinkedList getPasswordFileLines() throws Exception {
        LinkedList linkedList = new LinkedList();
        if (this.passwordFile.exists()) {
            linkedList = FileUtil.getFileLines(this.passwordFile);
        }
        return linkedList;
    }
}

