/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.authentication.HashingCipher;
import fitnesse.authentication.PasswordCipher;
import fitnesse.authentication.PasswordFile;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class Password {
    public static String defaultFile = "passwords.txt";
    public static String defaultCipher = "fitnesse.authentication.HashingCipher";
    private static BufferedReader input;
    private PasswordFile passwords;
    private String username;
    private String password;
    private PasswordCipher cipher = new HashingCipher();

    public static void main(String[] stringArray) throws Exception {
        Password password = new Password();
        if (!password.args(stringArray)) {
            Password.printUsage();
        }
        input = new BufferedReader(new InputStreamReader(System.in));
        password.interactForPassword();
        password.savePassword();
        System.out.println("password saved in " + password.passwords.getName());
    }

    public static void printUsage() {
        System.err.println("Usage: java fitnesse.authentication.Password [-f <password file>] [-c <password cipher>] <user>");
        System.err.println("\t-f <password file> {" + defaultFile + "}");
        System.err.println("\t-c <password cipher> {" + defaultCipher + "}");
        System.exit(-1);
    }

    public Password(String string) throws Exception {
        this.passwords = new PasswordFile(string, this.cipher);
    }

    public Password() throws Exception {
        this(defaultFile);
    }

    public void savePassword() throws Exception {
        this.passwords.savePassword(this.username, this.password);
    }

    public boolean args(String[] stringArray) {
        if (stringArray.length < 1 || stringArray.length > 5) {
            return false;
        }
        try {
            boolean bl = false;
            int n = 0;
            while (!bl) {
                if (stringArray[n].startsWith("-")) {
                    if ("-f".equals(stringArray[n])) {
                        this.passwords = new PasswordFile(stringArray[n + 1], this.cipher);
                        n += 2;
                        continue;
                    }
                    if ("-c".equals(stringArray[n])) {
                        this.cipher = this.passwords.instantiateCipher(stringArray[n + 1]);
                        n += 2;
                        continue;
                    }
                    return false;
                }
                this.username = stringArray[n];
                bl = true;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getFilename() {
        return this.passwords.getName();
    }

    public PasswordCipher getCipher() {
        return this.cipher;
    }

    private void interactForPassword() throws Exception {
        while (this.password == null) {
            System.out.println("Be advised, the password will be visible as it is typed.");
            System.out.print("enter password for " + this.username + ": ");
            String string = this.getUserEntry();
            System.out.print("confirm password: ");
            String string2 = this.getUserEntry();
            if (string != null && string.equals(string2)) {
                this.password = string;
                continue;
            }
            System.out.println("");
            System.out.println("passwords did not match");
        }
    }

    private String getUserEntry() throws Exception {
        return input.readLine();
    }
}

