/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.authentication.SecureOperation;
import fitnesse.http.Request;
import fitnesse.responders.SecureResponder;
import fitnesse.responders.UnauthorizedResponder;

public abstract class Authenticator {
    public Responder authenticate(FitNesseContext fitNesseContext, Request request, Responder responder) throws Exception {
        request.getCredentials();
        String string = request.getAuthorizationUsername();
        String string2 = request.getAuthorizationPassword();
        if (this.isAuthenticated(string, string2)) {
            return responder;
        }
        if (!this.isSecureResponder(responder)) {
            return responder;
        }
        return this.verifyOperationIsSecure(responder, fitNesseContext, request);
    }

    private Responder verifyOperationIsSecure(Responder responder, FitNesseContext fitNesseContext, Request request) {
        SecureOperation secureOperation = ((SecureResponder)responder).getSecureOperation();
        try {
            if (secureOperation.shouldAuthenticate(fitNesseContext, request)) {
                return new UnauthorizedResponder();
            }
            return responder;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new UnauthorizedResponder();
        }
    }

    private boolean isSecureResponder(Responder responder) {
        return responder instanceof SecureResponder;
    }

    public abstract boolean isAuthenticated(String var1, String var2) throws Exception;

    public String toString() {
        return this.getClass().getName();
    }
}

