/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.components.CommandLine;
import fitnesse.http.RequestBuilder;
import fitnesse.http.Response;
import fitnesse.http.ResponseParser;

public class Shutdown {
    public String hostname = "localhost";
    public int port = 80;
    public String username;
    public String password;
    private CommandLine commandLine = new CommandLine("[-h hostname] [-p port] [-c username password]");

    public static void main(String[] stringArray) throws Exception {
        Shutdown shutdown = new Shutdown();
        shutdown.run(stringArray);
    }

    private void run(String[] stringArray) throws Exception {
        ResponseParser responseParser;
        String string;
        if (!this.parseArgs(stringArray)) {
            this.usage();
        }
        if (!"OK".equals(string = this.checkResponse(responseParser = this.buildAndSendRequest()))) {
            System.err.println("Failed to shutdown.");
            System.err.println(string);
            System.exit(responseParser.getStatus());
        }
    }

    public ResponseParser buildAndSendRequest() throws Exception {
        RequestBuilder requestBuilder = this.buildRequest();
        ResponseParser responseParser = ResponseParser.performHttpRequest(this.hostname, this.port, requestBuilder);
        return responseParser;
    }

    public RequestBuilder buildRequest() throws Exception {
        RequestBuilder requestBuilder = new RequestBuilder("/?responder=shutdown");
        if (this.username != null) {
            requestBuilder.addCredentials(this.username, this.password);
        }
        return requestBuilder;
    }

    public String checkResponse(ResponseParser responseParser) {
        int n = responseParser.getStatus();
        String string = responseParser.getHeader("Server");
        if (string == null || string.indexOf("FitNesse") == -1) {
            return "Not a FitNesse server";
        }
        if (n != 200) {
            return n + " " + Response.getReasonPhrase(n);
        }
        return "OK";
    }

    public boolean parseArgs(String[] stringArray) {
        if (!this.commandLine.parse(stringArray)) {
            return false;
        }
        if (this.commandLine.hasOption("h")) {
            this.hostname = this.commandLine.getOptionArgument("h", "hostname");
        }
        if (this.commandLine.hasOption("p")) {
            this.port = Integer.parseInt(this.commandLine.getOptionArgument("p", "port"));
        }
        if (this.commandLine.hasOption("c")) {
            this.username = this.commandLine.getOptionArgument("c", "username");
            this.password = this.commandLine.getOptionArgument("c", "password");
        }
        return true;
    }

    public void usage() {
        System.err.println("Usage: java fitnesse.Shutdown [-hpc]");
        System.err.println("\t-h <hostname> {localhost}");
        System.err.println("\t-p <port number> {80}");
        System.err.println("\t-c <username> <password> Supply user credentials.  Use when FitNesse has authentication activated.");
        System.exit(-1);
    }
}

