/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fit.ColumnFixture;
import fit.Fixture;
import fit.RowFixture;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class FixtureTemplateCreator {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            return;
        }
        new FixtureTemplateCreator().run(stringArray[0]);
    }

    public void run(String string) throws Exception {
        String string2 = "!|" + string + "|";
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string);
            Object obj = clazz.newInstance();
            if (!Fixture.class.isInstance(obj)) {
                throw new InstantiationException();
            }
            if (RowFixture.class.isInstance(obj)) {
                System.out.println(this.makeRowFixtureTemplate(string2, clazz));
            } else if (ColumnFixture.class.isInstance(obj)) {
                System.out.println(this.makeColumnFixtureTemplate(string2, clazz));
            } else {
                System.out.println(string2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("# Could not find " + string + " in the classpath. #");
        }
        catch (InstantiationException instantiationException) {
            System.out.println("# " + string + " is not a valid fixture! #");
        }
    }

    private StringBuffer makeRowFixtureTemplate(String string, Class clazz) {
        Class clazz2 = this.getTargetClassFromRowFixture(clazz);
        return this.makeFixtureTemplate(string, clazz2, Object.class);
    }

    private StringBuffer makeColumnFixtureTemplate(String string, Class clazz) {
        return this.makeFixtureTemplate(string, clazz, ColumnFixture.class);
    }

    private StringBuffer makeFixtureTemplate(String string, Class clazz, Class clazz2) {
        StringBuffer stringBuffer = new StringBuffer(string + "\n");
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.getPublicMembers(clazz, arrayList, arrayList2, clazz2);
        this.addCellsForColumnFixture(stringBuffer, arrayList, arrayList2);
        return stringBuffer;
    }

    private void getPublicMembers(Class clazz, List list, List list2, Class clazz2) {
        for (Class clazz3 = clazz; clazz3 != clazz2; clazz3 = clazz3.getSuperclass()) {
            Field[] fieldArray = clazz3.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                if (!Modifier.isPublic(field.getModifiers())) continue;
                list.add(field);
            }
            Method[] methodArray = clazz3.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                String string = method.getName();
                if ("reset".equals(string) || "execute".equals(string) || Modifier.isAbstract(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
                list2.add(method);
            }
        }
    }

    private void addCellsForColumnFixture(StringBuffer stringBuffer, List list, List list2) {
        StringBuffer stringBuffer2 = new StringBuffer("|");
        StringBuffer stringBuffer3 = new StringBuffer("|");
        this.addCellsForFieldNamesAndTypes(list, stringBuffer2, stringBuffer3);
        this.addCellsForMethodNamesAndReturnTypes(list2, stringBuffer2, stringBuffer3);
        stringBuffer.append(stringBuffer2).append("\n").append(stringBuffer3).append("\n");
    }

    private void addCellsForFieldNamesAndTypes(List list, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        for (Field field : list) {
            String string = field.getName();
            String string2 = this.getShortClassName(field.getType().getName());
            String string3 = this.createSpaces(Math.abs(string.length() - string2.length()));
            if (string.length() < string2.length()) {
                string = string + string3;
            } else if (string2.length() < string.length()) {
                string2 = string2 + string3;
            }
            stringBuffer.append(string).append("|");
            stringBuffer2.append(string2).append("|");
        }
    }

    private void addCellsForMethodNamesAndReturnTypes(List list, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        for (Method method : list) {
            String string = method.getName() + "()";
            String string2 = this.getShortClassName(method.getReturnType().getName());
            string2 = this.fixClassName(string2);
            String string3 = this.createSpaces(Math.abs(string.length() - string2.length()));
            if (string.length() < string2.length()) {
                string = string + string3;
            } else if (string2.length() < string.length()) {
                string2 = string2 + string3;
            }
            stringBuffer.append(string).append("|");
            stringBuffer2.append(string2).append("|");
        }
    }

    private String createSpaces(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    protected String getShortClassName(String string) {
        String[] stringArray = string.split("\\.");
        return stringArray[stringArray.length - 1];
    }

    protected String fixClassName(String string) {
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1) + "[]";
        }
        return string;
    }

    protected Class getTargetClassFromRowFixture(Class clazz) {
        Class clazz2 = null;
        try {
            Method method = clazz.getMethod("getTargetClass", null);
            clazz2 = (Class)method.invoke(clazz.newInstance(), null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return clazz2;
    }
}

