/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.components.LogData;
import fitnesse.http.HttpException;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.responders.ErrorResponder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.GregorianCalendar;

public class FitNesseExpediter
implements ResponseSender {
    private Socket socket;
    private InputStream input;
    private OutputStream output;
    private Request request;
    private Response response;
    private FitNesseContext context;
    protected long requestParsingTimeLimit;
    private long requestProgress;
    private long requestParsingDeadline;
    private boolean hasError;

    public FitNesseExpediter(Socket socket, FitNesseContext fitNesseContext) throws Exception {
        this.context = fitNesseContext;
        this.socket = socket;
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
        this.requestParsingTimeLimit = 10000L;
    }

    public void start() throws Exception {
        try {
            Request request = this.makeRequest();
            this.makeResponse(request);
            this.sendResponse();
        }
        catch (SocketException socketException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setRequestParsingTimeLimit(long l) {
        this.requestParsingTimeLimit = l;
    }

    public long getRequestParsingTimeLimit() {
        return this.requestParsingTimeLimit;
    }

    public void send(byte[] byArray) throws Exception {
        try {
            this.output.write(byArray);
            this.output.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() throws Exception {
        try {
            this.log(this.socket, this.request, this.response);
            this.socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Socket getSocket() throws Exception {
        return this.socket;
    }

    public Request makeRequest() throws Exception {
        this.request = new Request(this.input);
        return this.request;
    }

    public void sendResponse() throws Exception {
        this.response.readyToSend(this);
    }

    private Response makeResponse(Request request) throws Exception {
        try {
            Thread thread = this.createParsingThread(request);
            thread.start();
            this.waitForRequest(request);
            if (!this.hasError) {
                this.response = this.createGoodResponse(request);
            }
        }
        catch (SocketException socketException) {
            throw socketException;
        }
        catch (Exception exception) {
            this.response = new ErrorResponder(exception).makeResponse(this.context, request);
        }
        return this.response;
    }

    public Response createGoodResponse(Request request) throws Exception {
        Responder responder = this.context.responderFactory.makeResponder(request, this.context.root);
        responder = this.context.authenticator.authenticate(this.context, request, responder);
        Response response = responder.makeResponse(this.context, request);
        response.addHeader("Server", "FitNesse-20060719");
        response.addHeader("Connection", "close");
        return response;
    }

    private void waitForRequest(Request request) throws InterruptedException {
        long l = System.currentTimeMillis();
        this.requestParsingDeadline = l + this.requestParsingTimeLimit;
        this.requestProgress = 0L;
        while (!this.hasError && !request.hasBeenParsed()) {
            Thread.sleep(10L);
            if (!this.timeIsUp(l) || !this.parsingIsUnproductive(request)) continue;
            this.reportError(408, "The client request has been unproductive for too long.  It has timed out and will now longer be processed");
        }
    }

    private boolean parsingIsUnproductive(Request request) {
        long l = request.numberOfBytesParsed();
        if (l > this.requestProgress) {
            this.requestProgress = l;
            return false;
        }
        return true;
    }

    private boolean timeIsUp(long l) {
        l = System.currentTimeMillis();
        if (l > this.requestParsingDeadline) {
            this.requestParsingDeadline = l + this.requestParsingTimeLimit;
            return true;
        }
        return false;
    }

    private Thread createParsingThread(final Request request) {
        Thread thread = new Thread(){

            public synchronized void run() {
                try {
                    request.parse();
                }
                catch (HttpException httpException) {
                    FitNesseExpediter.this.reportError(400, httpException.getMessage());
                }
                catch (Exception exception) {
                    FitNesseExpediter.this.reportError(exception);
                }
            }
        };
        return thread;
    }

    private void reportError(int n, String string) {
        try {
            this.response = new ErrorResponder(string).makeResponse(this.context, this.request);
            this.response.setStatus(n);
            this.hasError = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void reportError(Exception exception) {
        try {
            this.response = new ErrorResponder(exception).makeResponse(this.context, this.request);
            this.hasError = true;
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
        }
    }

    public static LogData makeLogData(Socket socket, Request request, Response response) {
        LogData logData = new LogData();
        logData.host = ((InetSocketAddress)socket.getRemoteSocketAddress()).getAddress().getHostAddress();
        logData.time = new GregorianCalendar();
        logData.requestLine = request.getRequestLine();
        logData.status = response.getStatus();
        logData.size = response.getContentSize();
        logData.username = request.getAuthorizationUsername();
        return logData;
    }

    public void log(Socket socket, Request request, Response response) throws Exception {
        if (this.context.logger != null) {
            this.context.logger.log(FitNesseExpediter.makeLogData(socket, request, response));
        }
    }
}

