/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.Arguments;
import fitnesse.ComponentFactory;
import fitnesse.FitNesseContext;
import fitnesse.FitNesseServer;
import fitnesse.authentication.Authenticator;
import fitnesse.authentication.MultiUserAuthenticator;
import fitnesse.authentication.OneUserAuthenticator;
import fitnesse.authentication.PromiscuousAuthenticator;
import fitnesse.components.CommandLine;
import fitnesse.components.Logger;
import fitnesse.html.HtmlPageFactory;
import fitnesse.responders.ResponderFactory;
import fitnesse.responders.WikiImportTestEventListener;
import fitnesse.socketservice.SocketService;
import fitnesse.updates.Updater;
import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.PageVersionPruner;
import java.io.File;
import java.net.BindException;

public class FitNesse {
    public static final String VERSION = "20060719";
    private FitNesseContext context = new FitNesseContext();
    private SocketService theService;
    private static String extraOutput;

    public static void main(String[] stringArray) throws Exception {
        Arguments arguments = FitNesse.parseCommandLine(stringArray);
        if (arguments != null) {
            boolean bl;
            FitNesseContext fitNesseContext = FitNesse.loadContext(arguments);
            PageVersionPruner.daysTillVersionsExpire = arguments.getDaysTillVersionsExpire();
            FitNesse fitNesse = new FitNesse(fitNesseContext);
            if (!arguments.isOmittingUpdates()) {
                fitNesse.applyUpdates();
            }
            if (bl = fitNesse.start()) {
                FitNesse.printStartMessage(arguments, fitNesseContext);
            }
        } else {
            FitNesse.printUsage();
            System.exit(1);
        }
    }

    private static FitNesseContext loadContext(Arguments arguments) throws Exception {
        FitNesseContext fitNesseContext = new FitNesseContext();
        ComponentFactory componentFactory = new ComponentFactory(fitNesseContext.rootPath);
        fitNesseContext.port = arguments.getPort();
        fitNesseContext.rootPath = arguments.getRootPath();
        fitNesseContext.rootPageName = arguments.getRootDirectory();
        fitNesseContext.rootPagePath = fitNesseContext.rootPath + "/" + fitNesseContext.rootPageName;
        fitNesseContext.root = componentFactory.getRootPage(FileSystemPage.makeRoot(fitNesseContext.rootPath, fitNesseContext.rootPageName));
        fitNesseContext.responderFactory = new ResponderFactory(fitNesseContext.rootPagePath);
        fitNesseContext.logger = FitNesse.makeLogger(arguments);
        fitNesseContext.authenticator = FitNesse.makeAuthenticator(arguments.getUserpass(), componentFactory);
        fitNesseContext.htmlPageFactory = componentFactory.getHtmlPageFactory(new HtmlPageFactory());
        extraOutput = componentFactory.loadResponderPlugins(fitNesseContext.responderFactory);
        extraOutput = extraOutput + componentFactory.loadWikiWidgetPlugins();
        extraOutput = extraOutput + componentFactory.loadContentFilter();
        WikiImportTestEventListener.register();
        return fitNesseContext;
    }

    public static Arguments parseCommandLine(String[] stringArray) {
        CommandLine commandLine = new CommandLine("[-p port][-d dir][-r root][-l logDir][-e days][-o][-a userpass]");
        Arguments arguments = null;
        if (commandLine.parse(stringArray)) {
            arguments = new Arguments();
            if (commandLine.hasOption("p")) {
                arguments.setPort(commandLine.getOptionArgument("p", "port"));
            }
            if (commandLine.hasOption("d")) {
                arguments.setRootPath(commandLine.getOptionArgument("d", "dir"));
            }
            if (commandLine.hasOption("r")) {
                arguments.setRootDirectory(commandLine.getOptionArgument("r", "root"));
            }
            if (commandLine.hasOption("l")) {
                arguments.setLogDirectory(commandLine.getOptionArgument("l", "logDir"));
            }
            if (commandLine.hasOption("e")) {
                arguments.setDaysTillVersionsExpire(commandLine.getOptionArgument("e", "days"));
            }
            if (commandLine.hasOption("a")) {
                arguments.setUserpass(commandLine.getOptionArgument("a", "userpass"));
            }
            arguments.setOmitUpdates(commandLine.hasOption("o"));
        }
        return arguments;
    }

    private static Logger makeLogger(Arguments arguments) {
        String string = arguments.getLogDirectory();
        return string != null ? new Logger(string) : null;
    }

    public static Authenticator makeAuthenticator(String string, ComponentFactory componentFactory) throws Exception {
        Authenticator authenticator = new PromiscuousAuthenticator();
        if (string != null) {
            if (new File(string).exists()) {
                authenticator = new MultiUserAuthenticator(string);
            } else {
                String[] stringArray = string.split(":");
                authenticator = new OneUserAuthenticator(stringArray[0], stringArray[1]);
            }
        }
        return componentFactory.getAuthenticator(authenticator);
    }

    private static void printUsage() {
        System.err.println("Usage: java fitnesse.FitNesse [-pdrleoa]");
        System.err.println("\t-p <port number> {80}");
        System.err.println("\t-d <working directory> {.}");
        System.err.println("\t-r <page root directory> {FitNesseRoot}");
        System.err.println("\t-l <log directory> {no logging}");
        System.err.println("\t-e <days> {14} Number of days before page versions expire");
        System.err.println("\t-o omit updates");
        System.err.println("\t-a {user:pwd | user-file-name} enable authentication.");
    }

    private static void printStartMessage(Arguments arguments, FitNesseContext fitNesseContext) {
        System.out.println("FitNesse (20060719) Started...");
        System.out.print(fitNesseContext.toString());
        System.out.println("\tpage version expiration set to " + arguments.getDaysTillVersionsExpire() + " days.");
        System.out.print(extraOutput);
    }

    private static void printBadPortMessage(int n) {
        System.err.println("FitNesse cannot be started...");
        System.err.println("Port " + n + " is already in use.");
        System.err.println("Use the -p <port#> command line argument to use a different port.");
    }

    private static void establishDirectory(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public FitNesse(FitNesseContext fitNesseContext) throws Exception {
        this(fitNesseContext, true);
    }

    public FitNesse(FitNesseContext fitNesseContext, boolean bl) {
        this.context = fitNesseContext;
        fitNesseContext.fitnesse = this;
        if (bl) {
            this.establishRequiredDirectories();
        }
    }

    public boolean start() {
        try {
            this.theService = new SocketService(this.context.port, new FitNesseServer(this.context));
            return true;
        }
        catch (BindException bindException) {
            FitNesse.printBadPortMessage(this.context.port);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public void stop() throws Exception {
        if (this.theService != null) {
            this.theService.close();
            this.theService = null;
        }
    }

    private void establishRequiredDirectories() {
        FitNesse.establishDirectory(this.context.rootPagePath);
        FitNesse.establishDirectory(this.context.rootPagePath + "/files");
    }

    public void applyUpdates() throws Exception {
        Updater updater = new Updater(this.context);
        updater.update();
    }

    public boolean isRunning() {
        return this.theService != null;
    }
}

