/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fit.Fixture;
import fit.Parse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class FitFilter {
    public String input;
    public Parse tables;
    public Fixture fixture = new Fixture();
    public PrintWriter output;

    public static void main(String[] stringArray) {
        new FitFilter().run(stringArray);
    }

    public void run(String[] stringArray) {
        this.args(stringArray);
        this.process();
        this.exit();
    }

    public void process() {
        try {
            this.tables = new Parse(this.input);
            this.fixture.doTables(this.tables);
        }
        catch (Exception exception) {
            this.exception(exception);
        }
        this.tables.print(this.output);
    }

    public void args(String[] stringArray) {
        if (stringArray.length != 0) {
            System.err.println("usage: java fitnesse.FitFilter");
            System.exit(-1);
        }
        try {
            this.input = this.read();
            this.output = new PrintWriter(System.out);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(-1);
        }
    }

    protected String read() throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    protected void exception(Exception exception) {
        this.tables = new Parse("body", "Unable to parse input. Input ignored.", null, null);
        this.fixture.exception(this.tables, exception);
    }

    protected void exit() {
        this.output.close();
        System.exit(this.fixture.counts.wrong + this.fixture.counts.exceptions);
    }
}

