/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.authentication.Authenticator;
import fitnesse.html.HtmlPageFactory;
import fitnesse.responders.ResponderFactory;
import fitnesse.responders.editing.ContentFilter;
import fitnesse.responders.editing.SaveResponder;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.WidgetBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ComponentFactory {
    private final String endl = System.getProperty("line.separator");
    public static final String PROPERTIES_FILE = "plugins.properties";
    public static final String WIKI_PAGE_CLASS = "WikiPage";
    public static final String HTML_PAGE_FACTORY = "HtmlPageFactory";
    public static final String RESPONDERS = "Responders";
    public static final String WIKI_WIDGETS = "WikiWidgets";
    public static final String AUTHENTICATOR = "Authenticator";
    public static final String CONTENT_FILTER = "ContentFilter";
    private Properties loadedProperties;
    private String propertiesLocation;

    public ComponentFactory(String string) {
        this(string, new Properties());
    }

    public ComponentFactory(String string, Properties properties) {
        this.propertiesLocation = string;
        this.loadedProperties = properties;
        this.loadProperties();
    }

    public void loadProperties() {
        try {
            this.loadedProperties.load(new FileInputStream(this.propertiesLocation + "/" + PROPERTIES_FILE));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Object createComponent(String string) throws Exception {
        String string2 = this.loadedProperties.getProperty(string);
        if (string2 != null) {
            Class<?> clazz = Class.forName(string2);
            Constructor<?> constructor = clazz.getConstructor(Properties.class);
            return constructor.newInstance(this.loadedProperties);
        }
        return null;
    }

    public WikiPage getRootPage(WikiPage wikiPage) throws Exception {
        String string = this.loadedProperties.getProperty(WIKI_PAGE_CLASS);
        if (string != null) {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod("makeRoot", Properties.class);
            return (WikiPage)method.invoke(clazz, this.loadedProperties);
        }
        return wikiPage;
    }

    public HtmlPageFactory getHtmlPageFactory(HtmlPageFactory htmlPageFactory) throws Exception {
        HtmlPageFactory htmlPageFactory2 = (HtmlPageFactory)this.createComponent(HTML_PAGE_FACTORY);
        return htmlPageFactory2 == null ? htmlPageFactory : htmlPageFactory2;
    }

    public String loadResponderPlugins(ResponderFactory responderFactory) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.loadedProperties.getProperty(RESPONDERS);
        if (string != null) {
            stringBuffer.append("\tCustom responders loaded:").append(this.endl);
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                String[] stringArray2 = string2.split(":");
                String string3 = stringArray2[0];
                Class<?> clazz = Class.forName(stringArray2[1]);
                responderFactory.addResponder(string3, clazz);
                stringBuffer.append("\t\t" + string3 + ":" + clazz.getName()).append(this.endl);
            }
        }
        return stringBuffer.toString();
    }

    public Authenticator getAuthenticator(Authenticator authenticator) throws Exception {
        Authenticator authenticator2 = (Authenticator)this.createComponent(AUTHENTICATOR);
        return authenticator2 == null ? authenticator : authenticator2;
    }

    public String loadWikiWidgetPlugins() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.loadedProperties.getProperty(WIKI_WIDGETS);
        if (string != null) {
            ArrayList arrayList = new ArrayList();
            stringBuffer.append("\tCustom wiki widgets loaded:").append(this.endl);
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                Class<?> clazz = Class.forName(string2);
                arrayList.add(clazz);
                stringBuffer.append("\t\t" + clazz.getName()).append(this.endl);
            }
            this.appendExistingWidgets(arrayList);
            Class[] classArray = arrayList.toArray(new Class[0]);
            WidgetBuilder.htmlWidgetBuilder = new WidgetBuilder(classArray);
        }
        return stringBuffer.toString();
    }

    private void appendExistingWidgets(List list) {
        for (int i = 0; i < WidgetBuilder.htmlWidgetClasses.length; ++i) {
            Class clazz = WidgetBuilder.htmlWidgetClasses[i];
            list.add(clazz);
        }
    }

    public String loadContentFilter() throws Exception {
        ContentFilter contentFilter = (ContentFilter)this.createComponent(CONTENT_FILTER);
        if (contentFilter != null) {
            SaveResponder.contentFilter = contentFilter;
            return "\tContent filter installed: " + contentFilter.getClass().getName() + "\n";
        }
        return "";
    }
}

