/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Fixture;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class TypeAdapter {
    public Object target;
    public Fixture fixture;
    public Field field;
    public Method method;
    public Class type;

    public static TypeAdapter on(Fixture fixture, Class clazz) {
        TypeAdapter typeAdapter = TypeAdapter.adapterFor(clazz);
        typeAdapter.init(fixture, clazz);
        return typeAdapter;
    }

    public static TypeAdapter on(Fixture fixture, Field field) {
        TypeAdapter typeAdapter = TypeAdapter.on(fixture, field.getType());
        typeAdapter.target = fixture;
        typeAdapter.field = field;
        return typeAdapter;
    }

    public static TypeAdapter on(Fixture fixture, Method method) {
        TypeAdapter typeAdapter = TypeAdapter.on(fixture, method.getReturnType());
        typeAdapter.target = fixture;
        typeAdapter.method = method;
        return typeAdapter;
    }

    public static TypeAdapter adapterFor(Class clazz) throws UnsupportedOperationException {
        if (clazz.isPrimitive()) {
            if (clazz.equals(Byte.TYPE)) {
                return new ByteAdapter();
            }
            if (clazz.equals(Short.TYPE)) {
                return new ShortAdapter();
            }
            if (clazz.equals(Integer.TYPE)) {
                return new IntAdapter();
            }
            if (clazz.equals(Long.TYPE)) {
                return new LongAdapter();
            }
            if (clazz.equals(Float.TYPE)) {
                return new FloatAdapter();
            }
            if (clazz.equals(Double.TYPE)) {
                return new DoubleAdapter();
            }
            if (clazz.equals(Character.TYPE)) {
                return new CharAdapter();
            }
            if (clazz.equals(Boolean.TYPE)) {
                return new BooleanAdapter();
            }
            throw new UnsupportedOperationException("can't yet adapt " + clazz);
        }
        if (clazz.equals(Byte.class)) {
            return new ClassByteAdapter();
        }
        if (clazz.equals(Short.class)) {
            return new ClassShortAdapter();
        }
        if (clazz.equals(Integer.class)) {
            return new ClassIntegerAdapter();
        }
        if (clazz.equals(Long.class)) {
            return new ClassLongAdapter();
        }
        if (clazz.equals(Float.class)) {
            return new ClassFloatAdapter();
        }
        if (clazz.equals(Double.class)) {
            return new ClassDoubleAdapter();
        }
        if (clazz.equals(Character.class)) {
            return new ClassCharacterAdapter();
        }
        if (clazz.equals(Boolean.class)) {
            return new ClassBooleanAdapter();
        }
        if (clazz.isArray()) {
            return new ArrayAdapter();
        }
        return new TypeAdapter();
    }

    public void init(Fixture fixture, Class clazz) {
        this.fixture = fixture;
        this.type = clazz;
    }

    public Object get() throws IllegalAccessException, InvocationTargetException {
        if (this.field != null) {
            return this.field.get(this.target);
        }
        if (this.method != null) {
            return this.invoke();
        }
        return null;
    }

    public void set(Object object) throws Exception {
        this.field.set(this.target, object);
    }

    public Object invoke() throws IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{};
        return this.method.invoke(this.target, objectArray);
    }

    public Object parse(String string) throws Exception {
        return this.fixture.parse(string, this.type);
    }

    public boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String && ((String)object).equals("")) {
            return "blank";
        }
        return object.toString();
    }

    static class ArrayAdapter
    extends TypeAdapter {
        Class componentType;
        TypeAdapter componentAdapter;

        ArrayAdapter() {
        }

        public void init(Fixture fixture, Class clazz) {
            super.init(fixture, clazz);
            this.componentType = clazz.getComponentType();
            this.componentAdapter = ArrayAdapter.on(fixture, this.componentType);
        }

        public Object parse(String string) throws Exception {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            Object object = Array.newInstance(this.componentType, stringTokenizer.countTokens());
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                Array.set(object, n, this.componentAdapter.parse(stringTokenizer.nextToken().trim()));
                ++n;
            }
            return object;
        }

        public String toString(Object object) {
            if (object == null) {
                return "";
            }
            int n = Array.getLength(object);
            StringBuffer stringBuffer = new StringBuffer(5 * n);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this.componentAdapter.toString(Array.get(object, i)));
                if (i >= n - 1) continue;
                stringBuffer.append(", ");
            }
            return stringBuffer.toString();
        }

        public boolean equals(Object object, Object object2) {
            int n = Array.getLength(object);
            if (n != Array.getLength(object2)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.componentAdapter.equals(Array.get(object, i), Array.get(object2, i))) continue;
                return false;
            }
            return true;
        }
    }

    static class ClassBooleanAdapter
    extends TypeAdapter {
        ClassBooleanAdapter() {
        }

        public Object parse(String string) {
            String string2 = string.toLowerCase();
            if (string2.equals("true")) {
                return new Boolean(true);
            }
            if (string2.equals("yes")) {
                return new Boolean(true);
            }
            if (string2.equals("1")) {
                return new Boolean(true);
            }
            if (string2.equals("y")) {
                return new Boolean(true);
            }
            if (string2.equals("+")) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }
    }

    static class BooleanAdapter
    extends ClassBooleanAdapter {
        BooleanAdapter() {
        }

        public void set(Object object) throws IllegalAccessException {
            this.field.setBoolean(this.target, (Boolean)object);
        }
    }

    static class ClassCharacterAdapter
    extends TypeAdapter {
        ClassCharacterAdapter() {
        }

        public Object parse(String string) {
            return new Character(string.charAt(0));
        }
    }

    static class CharAdapter
    extends ClassCharacterAdapter {
        CharAdapter() {
        }

        public void set(Object object) throws IllegalAccessException {
            this.field.setChar(this.target, ((Character)object).charValue());
        }
    }

    static class ClassDoubleAdapter
    extends TypeAdapter {
        ClassDoubleAdapter() {
        }

        public Object parse(String string) {
            return new Double(Double.parseDouble(string));
        }
    }

    static class DoubleAdapter
    extends ClassDoubleAdapter {
        DoubleAdapter() {
        }

        public void set(Object object) throws IllegalAccessException {
            this.field.setDouble(this.target, ((Number)object).doubleValue());
        }

        public Object parse(String string) {
            return new Double(Double.parseDouble(string));
        }
    }

    static class ClassFloatAdapter
    extends TypeAdapter {
        ClassFloatAdapter() {
        }

        public Object parse(String string) {
            return new Float(Float.parseFloat(string));
        }
    }

    static class FloatAdapter
    extends ClassFloatAdapter {
        FloatAdapter() {
        }

        public void set(Object object) throws IllegalAccessException {
            this.field.setFloat(this.target, ((Number)object).floatValue());
        }

        public Object parse(String string) {
            return new Float(Float.parseFloat(string));
        }
    }

    static class ClassLongAdapter
    extends TypeAdapter {
        ClassLongAdapter() {
        }

        public Object parse(String string) {
            return new Long(Long.parseLong(string));
        }
    }

    static class LongAdapter
    extends ClassLongAdapter {
        LongAdapter() {
        }

        public void set(Long l) throws IllegalAccessException {
            this.field.setLong(this.target, l);
        }
    }

    static class ClassIntegerAdapter
    extends TypeAdapter {
        ClassIntegerAdapter() {
        }

        public Object parse(String string) {
            return new Integer(Integer.parseInt(string));
        }
    }

    static class IntAdapter
    extends ClassIntegerAdapter {
        IntAdapter() {
        }

        public void set(Object object) throws IllegalAccessException {
            this.field.setInt(this.target, (Integer)object);
        }
    }

    static class ClassShortAdapter
    extends TypeAdapter {
        ClassShortAdapter() {
        }

        public Object parse(String string) {
            return new Short(Short.parseShort(string));
        }
    }

    static class ShortAdapter
    extends ClassShortAdapter {
        ShortAdapter() {
        }

        public void set(Object object) throws IllegalAccessException {
            this.field.setShort(this.target, (Short)object);
        }
    }

    static class ClassByteAdapter
    extends TypeAdapter {
        ClassByteAdapter() {
        }

        public Object parse(String string) {
            return new Byte(Byte.parseByte(string));
        }
    }

    static class ByteAdapter
    extends ClassByteAdapter {
        ByteAdapter() {
        }

        public void set(Object object) throws IllegalAccessException {
            this.field.setByte(this.target, (Byte)object);
        }
    }
}

