/*
 * Decompiled with CFR 0.152.
 */
package fit;

public class ScientificDouble
extends Number
implements Comparable {
    protected double value;
    protected double precision;

    public ScientificDouble(double d) {
        this.value = d;
        this.precision = 0.0;
    }

    public static ScientificDouble valueOf(String string) {
        ScientificDouble scientificDouble = new ScientificDouble(Double.parseDouble(string));
        scientificDouble.precision = ScientificDouble.precision(string);
        return scientificDouble;
    }

    public static ScientificDouble parse(String string) {
        return ScientificDouble.valueOf(string);
    }

    public static double precision(String string) {
        double d = Double.parseDouble(string);
        double d2 = Double.parseDouble(ScientificDouble.tweak(string.trim()));
        return Math.abs(d2 - d);
    }

    public static String tweak(String string) {
        int n = string.toLowerCase().indexOf("e");
        if (n >= 0) {
            return ScientificDouble.tweak(string.substring(0, n)) + string.substring(n);
        }
        if (string.indexOf(".") >= 0) {
            return string + "5";
        }
        return string + ".5";
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        double d = ((Number)object).doubleValue();
        double d2 = this.value - d;
        if (d2 < -this.precision) {
            return -1;
        }
        if (d2 > this.precision) {
            return 1;
        }
        if (Double.isNaN(this.value) && Double.isNaN(d)) {
            return 0;
        }
        if (Double.isNaN(this.value)) {
            return 1;
        }
        if (Double.isNaN(d)) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }
}

