/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.exception.FitParseException;
import java.io.PrintWriter;

public class Parse {
    public String leader;
    public String tag;
    public String body;
    public String end;
    public String trailer;
    public Parse more;
    public Parse parts;
    public static String[] tags = new String[]{"table", "tr", "td"};

    public Parse(String string, String string2, Parse parse, Parse parse2) {
        this.leader = "\n";
        this.tag = "<" + string + ">";
        this.body = string2;
        this.end = "</" + string + ">";
        this.trailer = "";
        this.parts = parse;
        this.more = parse2;
    }

    public Parse(String string) throws FitParseException {
        this(string, tags, 0, 0);
    }

    public Parse(String string, String[] stringArray) throws FitParseException {
        this(string, stringArray, 0, 0);
    }

    public Parse(String string, String[] stringArray, int n, int n2) throws FitParseException {
        String string2 = string.toLowerCase();
        int n3 = string2.indexOf("<" + stringArray[n]);
        int n4 = string2.indexOf(">", n3) + 1;
        int n5 = Parse.findMatchingEndTag(string2, n4, stringArray[n], n2);
        int n6 = string2.indexOf(">", n5) + 1;
        int n7 = string2.indexOf("<" + stringArray[n], n6);
        if (n3 < 0 || n4 < 0 || n5 < 0 || n6 < 0) {
            throw new FitParseException("Can't find tag: " + stringArray[n], n2);
        }
        this.leader = string.substring(0, n3);
        this.tag = string.substring(n3, n4);
        this.body = string.substring(n4, n5);
        this.end = string.substring(n5, n6);
        this.trailer = string.substring(n6);
        if (n + 1 < stringArray.length) {
            this.parts = new Parse(this.body, stringArray, n + 1, n2 + n4);
            this.body = null;
        } else {
            int n8 = this.body.indexOf("<" + stringArray[0]);
            if (n8 >= 0) {
                this.parts = new Parse(this.body, stringArray, 0, n2 + n4);
                this.body = "";
            }
        }
        if (n7 >= 0) {
            this.more = new Parse(this.trailer, stringArray, n, n2 + n6);
            this.trailer = null;
        }
    }

    protected static int findMatchingEndTag(String string, int n, String string2, int n2) throws FitParseException {
        int n3 = n;
        int n4 = 1;
        int n5 = 0;
        while (n4 > 0) {
            int n6 = string.indexOf("<" + string2, n3);
            int n7 = string.indexOf("</" + string2, n3);
            if (n6 < 0 && n7 < 0) {
                throw new FitParseException("Can't find tag: " + string2, n2);
            }
            if (n6 < 0) {
                n6 = Integer.MAX_VALUE;
            }
            if (n7 < 0) {
                n7 = Integer.MAX_VALUE;
            }
            if (n6 < n7) {
                ++n4;
                n5 = n6;
                n3 = string.indexOf(">", n6) + 1;
                continue;
            }
            if (n7 >= n6) continue;
            --n4;
            n5 = n7;
            n3 = string.indexOf(">", n7) + 1;
        }
        return n5;
    }

    public int size() {
        return this.more == null ? 1 : this.more.size() + 1;
    }

    public Parse last() {
        return this.more == null ? this : this.more.last();
    }

    public Parse leaf() {
        return this.parts == null ? this : this.parts.leaf();
    }

    public Parse at(int n) {
        return n == 0 || this.more == null ? this : this.more.at(n - 1);
    }

    public Parse at(int n, int n2) {
        return this.at((int)n).parts.at(n2);
    }

    public Parse at(int n, int n2, int n3) {
        return this.at((int)n, (int)n2).parts.at(n3);
    }

    public String text() {
        return Parse.unescape(Parse.unformat(this.body)).trim();
    }

    public static String unformat(String string) {
        int n;
        int n2 = 0;
        while ((n2 = string.indexOf(60, n2)) >= 0 && (n = string.indexOf(62, n2 + 1)) > 0) {
            string = string.substring(0, n2) + string.substring(n + 1);
        }
        return string;
    }

    public static String unescape(String string) {
        int n = -1;
        while ((n = string.indexOf(38, n + 1)) >= 0) {
            int n2 = string.indexOf(59, n + 1);
            if (n2 <= 0) continue;
            String string2 = string.substring(n + 1, n2).toLowerCase();
            String string3 = null;
            string3 = Parse.replacement(string2);
            if (string3 == null) continue;
            string = string.substring(0, n) + string3 + string.substring(n2 + 1);
        }
        return string;
    }

    public static String replacement(String string) {
        if (string.equals("lt")) {
            return "<";
        }
        if (string.equals("gt")) {
            return ">";
        }
        if (string.equals("amp")) {
            return "&";
        }
        if (string.equals("nbsp")) {
            return " ";
        }
        return null;
    }

    public void addToTag(String string) {
        int n = this.tag.length() - 1;
        this.tag = this.tag.substring(0, n) + string + ">";
    }

    public void addToBody(String string) {
        this.body = this.body + string;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print(this.leader);
        printWriter.print(this.tag);
        if (this.parts != null) {
            this.parts.print(printWriter);
        } else {
            printWriter.print(this.body);
        }
        printWriter.print(this.end);
        if (this.more != null) {
            this.more.print(printWriter);
        } else {
            printWriter.print(this.trailer);
        }
    }
}

