/*
 * Decompiled with CFR 0.152.
 */
package fit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GracefulNamer {
    private static Pattern disgracefulNamePattern = Pattern.compile("\\w(?:[.]|\\w)*[^.]");
    private StringBuffer finalName = new StringBuffer();
    private GracefulNameState currentState = new OutOfWordState();

    static boolean isGracefulName(String string) {
        Matcher matcher = disgracefulNamePattern.matcher(string);
        return !matcher.matches();
    }

    static String disgrace(String string) {
        GracefulNamer gracefulNamer = new GracefulNamer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c)) {
                gracefulNamer.currentState.letter(c);
                continue;
            }
            if (Character.isDigit(c)) {
                gracefulNamer.currentState.digit(c);
                continue;
            }
            gracefulNamer.currentState.other(c);
        }
        return gracefulNamer.finalName.toString();
    }

    private GracefulNamer() {
    }

    private class OutOfWordState
    implements GracefulNameState {
        private OutOfWordState() {
        }

        public void letter(char c) {
            GracefulNamer.this.finalName.append(Character.toUpperCase(c));
            GracefulNamer.this.currentState = new InWordState();
        }

        public void digit(char c) {
            GracefulNamer.this.finalName.append(c);
            GracefulNamer.this.currentState = new InNumberState();
        }

        public void other(char c) {
        }
    }

    private class InNumberState
    implements GracefulNameState {
        private InNumberState() {
        }

        public void letter(char c) {
            GracefulNamer.this.finalName.append(Character.toUpperCase(c));
            GracefulNamer.this.currentState = new InWordState();
        }

        public void digit(char c) {
            GracefulNamer.this.finalName.append(c);
        }

        public void other(char c) {
            GracefulNamer.this.currentState = new OutOfWordState();
        }
    }

    private class InWordState
    implements GracefulNameState {
        private InWordState() {
        }

        public void letter(char c) {
            GracefulNamer.this.finalName.append(c);
        }

        public void digit(char c) {
            GracefulNamer.this.finalName.append(c);
            GracefulNamer.this.currentState = new InNumberState();
        }

        public void other(char c) {
            GracefulNamer.this.currentState = new OutOfWordState();
        }
    }

    private static interface GracefulNameState {
        public void letter(char var1);

        public void digit(char var1);

        public void other(char var1);
    }
}

