/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Fixture;
import fit.FixtureClass;
import fit.FixtureName;
import fit.exception.CouldNotLoadComponentFitFailureException;
import fit.exception.NoSuchFixtureException;
import java.util.HashSet;
import java.util.Set;

public class FixtureLoader {
    private static FixtureLoader instance;
    public Set fixturePathElements = new HashSet(){
        {
            this.add("fit");
        }
    };

    public static FixtureLoader instance() {
        if (instance == null) {
            instance = new FixtureLoader();
        }
        return instance;
    }

    public Fixture disgraceThenLoad(String string) throws Throwable {
        FixtureName fixtureName = new FixtureName(string);
        Fixture fixture = this.instantiateFirstValidFixtureClass(fixtureName);
        this.addPackageToFixturePath(fixture);
        return fixture;
    }

    private void addPackageToFixturePath(Fixture fixture) {
        Package package_ = fixture.getClass().getPackage();
        if (package_ != null) {
            this.addPackageToPath(package_.getName());
        }
    }

    public void addPackageToPath(String string) {
        this.fixturePathElements.add(string);
    }

    private Fixture instantiateFixture(String string) throws Throwable {
        Class clazz = this.loadFixtureClass(string);
        FixtureClass fixtureClass = new FixtureClass(clazz);
        return fixtureClass.newInstance();
    }

    private Class loadFixtureClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (classNotFoundException.getMessage().equals(string)) {
                throw new NoSuchFixtureException(string);
            }
            throw new CouldNotLoadComponentFitFailureException(classNotFoundException.getMessage(), string);
        }
    }

    private Fixture instantiateFirstValidFixtureClass(FixtureName fixtureName) throws Throwable {
        for (String string : fixtureName.getPotentialFixtureClassNames(this.fixturePathElements)) {
            try {
                return this.instantiateFixture(string);
            }
            catch (NoSuchFixtureException noSuchFixtureException) {
            }
        }
        throw new NoSuchFixtureException(fixtureName.toString());
    }
}

