/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Counts;
import fit.FitMatcher;
import fit.FixtureListener;
import fit.FixtureLoader;
import fit.NullFixtureListener;
import fit.Parse;
import fit.TypeAdapter;
import fit.exception.CouldNotParseFitFailureException;
import fit.exception.FitFailureException;
import fit.exception.FitMatcherException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Fixture {
    public Map summary = new HashMap();
    public Counts counts = new Counts();
    public FixtureListener listener = new NullFixtureListener();
    protected String[] args;
    private static HashMap symbols = new HashMap();

    protected Class getTargetClass() {
        return this.getClass();
    }

    public void doTables(Parse parse) {
        Parse parse2;
        this.summary.put("run date", new Date());
        this.summary.put("run elapsed time", new RunTime());
        if (parse != null && (parse2 = parse.at(0, 0, 0)) != null) {
            try {
                Fixture fixture = this.getLinkedFixtureWithArgs(parse);
                fixture.listener = this.listener;
                fixture.interpretTables(parse);
            }
            catch (Throwable throwable) {
                this.exception(parse2, throwable);
                this.interpretFollowingTables(parse);
            }
        }
        this.listener.tablesFinished(this.counts);
        Fixture.ClearSymbols();
    }

    public static void ClearSymbols() {
        symbols.clear();
    }

    protected void interpretTables(Parse parse) {
        try {
            this.getArgsForTable(parse);
            this.doTable(parse);
        }
        catch (Exception exception) {
            this.exception(parse.at(0, 0, 0), exception);
            this.listener.tableFinished(parse);
            return;
        }
        this.interpretFollowingTables(parse);
    }

    private void interpretFollowingTables(Parse parse) {
        this.listener.tableFinished(parse);
        parse = parse.more;
        while (parse != null) {
            Parse parse2 = parse.at(0, 0, 0);
            if (parse2 != null) {
                try {
                    Fixture fixture = this.getLinkedFixtureWithArgs(parse);
                    fixture.doTable(parse);
                }
                catch (Throwable throwable) {
                    this.exception(parse2, throwable);
                }
            }
            this.listener.tableFinished(parse);
            parse = parse.more;
        }
    }

    protected Fixture getLinkedFixtureWithArgs(Parse parse) throws Throwable {
        Parse parse2 = parse.at(0, 0, 0);
        Fixture fixture = Fixture.loadFixture(parse2.text());
        fixture.counts = this.counts;
        fixture.summary = this.summary;
        fixture.getArgsForTable(parse);
        return fixture;
    }

    public static Fixture loadFixture(String string) throws Throwable {
        return FixtureLoader.instance().disgraceThenLoad(string);
    }

    void getArgsForTable(Parse parse) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Parse parse2 = parse.parts.parts.more;
        while (parse2 != null) {
            arrayList.add(parse2.text());
            parse2 = parse2.more;
        }
        this.args = arrayList.toArray(new String[0]);
    }

    public void doTable(Parse parse) {
        this.doRows(parse.parts.more);
    }

    public void doRows(Parse parse) {
        while (parse != null) {
            Parse parse2 = parse.more;
            this.doRow(parse);
            parse = parse2;
        }
    }

    public void doRow(Parse parse) {
        this.doCells(parse.parts);
    }

    public void doCells(Parse parse) {
        int n = 0;
        while (parse != null) {
            try {
                this.doCell(parse, n);
            }
            catch (Exception exception) {
                this.exception(parse, exception);
            }
            parse = parse.more;
            ++n;
        }
    }

    public void doCell(Parse parse, int n) {
        this.ignore(parse);
    }

    public void right(Parse parse) {
        parse.addToTag(" class=\"pass\"");
        ++this.counts.right;
    }

    public void wrong(Parse parse) {
        parse.addToTag(" class=\"fail\"");
        ++this.counts.wrong;
    }

    public void wrong(Parse parse, String string) {
        this.wrong(parse);
        parse.addToBody(Fixture.label("expected") + "<hr>" + Fixture.escape(string) + Fixture.label("actual"));
    }

    public void ignore(Parse parse) {
        parse.addToTag(" class=\"ignore\"");
        ++this.counts.ignores;
    }

    public void exception(Parse parse, Throwable throwable) {
        while (throwable.getClass().equals(InvocationTargetException.class)) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        if (this.isFriendlyException(throwable)) {
            parse.addToBody("<hr/>" + Fixture.label(throwable.getMessage()));
        } else {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            parse.addToBody("<hr><pre><div class=\"fit_stacktrace\">" + stringWriter.toString() + "</div></pre>");
        }
        parse.addToTag(" class=\"error\"");
        ++this.counts.exceptions;
    }

    public boolean isFriendlyException(Throwable throwable) {
        return throwable instanceof FitFailureException;
    }

    public String counts() {
        return this.counts.toString();
    }

    public static String label(String string) {
        return " <span class=\"fit_label\">" + string + "</span>";
    }

    public static String gray(String string) {
        return " <span class=\"fit_grey\">" + string + "</span>";
    }

    public static String escape(String string) {
        return Fixture.escape(Fixture.escape(string, '&', "&amp;"), '<', "&lt;");
    }

    public static String escape(String string, char c, String string2) {
        int n = -1;
        while ((n = string.indexOf(c, n + 1)) >= 0) {
            if (n == 0) {
                string = string2 + string.substring(1);
                continue;
            }
            if (n == string.length()) {
                string = string.substring(0, n) + string2;
                continue;
            }
            string = string.substring(0, n) + string2 + string.substring(n + 1);
        }
        return string;
    }

    public static String camel(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringBuffer.append(stringTokenizer.nextToken());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2.substring(0, 1).toUpperCase());
            stringBuffer.append(string2.substring(1));
        }
        return stringBuffer.toString();
    }

    public Object parse(String string, Class clazz) throws Exception {
        if (clazz.equals(String.class)) {
            if (string.toLowerCase().equals("null")) {
                return null;
            }
            if (string.toLowerCase().equals("blank")) {
                return "";
            }
            return string;
        }
        if (clazz.equals(Date.class)) {
            return DateFormat.getDateInstance(3).parse(string);
        }
        if (Fixture.hasParseMethod(clazz)) {
            return Fixture.callParseMethod(clazz, string);
        }
        throw new CouldNotParseFitFailureException(string, clazz.getName());
    }

    public void check(Parse parse, TypeAdapter typeAdapter) {
        String string = parse.text();
        if (string.equals("")) {
            this.handleBlankCell(parse, typeAdapter);
        } else if (typeAdapter == null) {
            this.ignore(parse);
        } else if (string.equals("error")) {
            this.handleErrorInCell(typeAdapter, parse);
        } else {
            this.compareCellToResult(typeAdapter, parse);
        }
    }

    private void compareCellToResult(TypeAdapter typeAdapter, Parse parse) {
        new CellComparator().compareCellToResult(typeAdapter, parse);
    }

    public void handleBlankCell(Parse parse, TypeAdapter typeAdapter) {
        try {
            parse.addToBody(Fixture.gray(typeAdapter.toString(typeAdapter.get())));
        }
        catch (Exception exception) {
            parse.addToBody(Fixture.gray("error"));
        }
    }

    private void handleErrorInCell(TypeAdapter typeAdapter, Parse parse) {
        try {
            Object object = typeAdapter.invoke();
            this.wrong(parse, typeAdapter.toString(object));
        }
        catch (IllegalAccessException illegalAccessException) {
            this.exception(parse, illegalAccessException);
        }
        catch (Exception exception) {
            this.right(parse);
        }
    }

    public String[] getArgs() {
        return this.args;
    }

    public static void setSymbol(String string, Object object) {
        symbols.put(string, object);
    }

    public static Object getSymbol(String string) {
        return symbols.get(string);
    }

    public static boolean hasParseMethod(Class clazz) {
        try {
            clazz.getMethod("parse", String.class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static Object callParseMethod(Class clazz, String string) throws Exception {
        Method method = clazz.getMethod("parse", String.class);
        Object object = method.invoke(null, string);
        return object;
    }

    private class Unparseable {
        private Unparseable() {
        }
    }

    private class CellComparator {
        private Object result = null;
        private Object expected = null;
        private TypeAdapter typeAdapter;
        private Parse cell;

        private CellComparator() {
        }

        private void compareCellToResult(TypeAdapter typeAdapter, Parse parse) {
            this.typeAdapter = typeAdapter;
            this.cell = parse;
            try {
                this.result = this.typeAdapter.get();
                this.expected = this.parseCell();
                if (this.expected instanceof Unparseable) {
                    this.tryRelationalMatch();
                } else {
                    this.compare();
                }
            }
            catch (Exception exception) {
                Fixture.this.exception(this.cell, exception);
            }
        }

        private void compare() {
            if (this.typeAdapter.equals(this.expected, this.result)) {
                Fixture.this.right(this.cell);
            } else {
                Fixture.this.wrong(this.cell, this.typeAdapter.toString(this.result));
            }
        }

        private Object parseCell() {
            try {
                return this.typeAdapter.parse(this.cell.text());
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (ParseException parseException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return new Unparseable();
        }

        private void tryRelationalMatch() {
            Class clazz = this.typeAdapter.type;
            CouldNotParseFitFailureException couldNotParseFitFailureException = new CouldNotParseFitFailureException(this.cell.text(), clazz.getName());
            if (this.result != null) {
                FitMatcher fitMatcher = new FitMatcher(this.cell.text(), this.result);
                try {
                    if (fitMatcher.matches()) {
                        Fixture.this.right(this.cell);
                    } else {
                        Fixture.this.wrong(this.cell);
                    }
                    this.cell.body = fitMatcher.message();
                }
                catch (FitMatcherException fitMatcherException) {
                    Fixture.this.exception(this.cell, couldNotParseFitFailureException);
                }
                catch (Exception exception) {
                    Fixture.this.exception(this.cell, exception);
                }
            } else {
                Fixture.this.exception(this.cell, couldNotParseFitFailureException);
            }
        }
    }

    public class RunTime {
        long start = System.currentTimeMillis();
        long elapsed = 0L;

        public String toString() {
            this.elapsed = System.currentTimeMillis() - this.start;
            if (this.elapsed > 600000L) {
                return this.d(3600000L) + ":" + this.d(600000L) + this.d(60000L) + ":" + this.d(10000L) + this.d(1000L);
            }
            return this.d(60000L) + ":" + this.d(10000L) + this.d(1000L) + "." + this.d(100L) + this.d(10L);
        }

        String d(long l) {
            long l2 = this.elapsed / l;
            this.elapsed -= l2 * l;
            return Long.toString(l2);
        }
    }
}

