/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Counts;
import fit.Fixture;
import fit.FixtureListener;
import fit.Parse;
import fit.exception.FitParseException;
import fitnesse.components.CommandLine;
import fitnesse.components.FitProtocol;
import fitnesse.util.StreamReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;

public class FitServer {
    public String input;
    public Parse tables;
    public Fixture fixture = new Fixture();
    public FixtureListener fixtureListener = new TablePrintingFixtureListener();
    private Counts counts = new Counts();
    private OutputStream socketOutput;
    private StreamReader socketReader;
    private boolean verbose = false;
    private String host;
    private int port;
    private int socketToken;
    private Socket socket;

    public FitServer(String string, int n, boolean bl) {
        this.host = string;
        this.port = n;
        this.verbose = bl;
    }

    public FitServer() {
    }

    public static void main(String[] stringArray) throws Exception {
        FitServer fitServer = new FitServer();
        fitServer.run(stringArray);
        System.exit(fitServer.exitCode());
    }

    public void run(String[] stringArray) throws Exception {
        this.args(stringArray);
        this.establishConnection();
        this.validateConnection();
        this.process();
        this.closeConnection();
        this.exit();
    }

    public void closeConnection() throws IOException {
        this.socket.close();
    }

    public void process() {
        this.fixture.listener = this.fixtureListener;
        try {
            int n = 1;
            while ((n = FitProtocol.readSize(this.socketReader)) != 0) {
                try {
                    this.print("processing document of size: " + n + "\n");
                    String string = FitProtocol.readDocument(this.socketReader, n);
                    this.tables = new Parse(string);
                    this.newFixture().doTables(this.tables);
                    this.print("\tresults: " + this.fixture.counts() + "\n");
                    this.counts.tally(this.fixture.counts);
                }
                catch (FitParseException fitParseException) {
                    this.exception(fitParseException);
                }
            }
            this.print("completion signal recieved\n");
        }
        catch (Exception exception) {
            this.exception(exception);
        }
    }

    public String readDocument() throws Exception {
        int n = FitProtocol.readSize(this.socketReader);
        return FitProtocol.readDocument(this.socketReader, n);
    }

    protected Fixture newFixture() {
        this.fixture = new Fixture();
        this.fixture.listener = this.fixtureListener;
        return this.fixture;
    }

    public void args(String[] stringArray) {
        CommandLine commandLine = new CommandLine("[-v] host port socketToken");
        if (commandLine.parse(stringArray)) {
            this.host = commandLine.getArgument("host");
            this.port = Integer.parseInt(commandLine.getArgument("port"));
            this.socketToken = Integer.parseInt(commandLine.getArgument("socketToken"));
            this.verbose = commandLine.hasOption("v");
        } else {
            this.usage();
        }
    }

    private void usage() {
        System.out.println("usage: java fit.FitServer [-v] host port socketTicket");
        System.out.println("\t-v\tverbose");
        System.exit(-1);
    }

    protected void exception(Exception exception) {
        this.print("Exception occurred!\n");
        this.print("\t" + exception.getMessage() + "\n");
        this.tables = new Parse("span", "Exception occurred: ", null, null);
        this.fixture.exception(this.tables, exception);
        ++this.counts.exceptions;
        this.fixture.listener.tableFinished(this.tables);
        this.fixture.listener.tablesFinished(this.counts);
    }

    public void exit() throws Exception {
        this.print("exiting\n");
        this.print("\tend results: " + this.counts.toString() + "\n");
    }

    public int exitCode() {
        return this.counts.wrong + this.counts.exceptions;
    }

    public void establishConnection() throws Exception {
        this.establishConnection(this.makeHttpRequest());
    }

    public void establishConnection(String string) throws Exception {
        this.socket = new Socket(this.host, this.port);
        this.socketOutput = this.socket.getOutputStream();
        this.socketReader = new StreamReader(this.socket.getInputStream());
        byte[] byArray = string.getBytes("UTF-8");
        this.socketOutput.write(byArray);
        this.socketOutput.flush();
        this.print("http request sent\n");
    }

    private String makeHttpRequest() {
        return "GET /?responder=socketCatcher&ticket=" + this.socketToken + " HTTP/1.1\r\n\r\n";
    }

    public void validateConnection() throws Exception {
        this.print("validating connection...");
        int n = FitProtocol.readSize(this.socketReader);
        if (n == 0) {
            this.print("...ok\n");
        } else {
            String string = FitProtocol.readDocument(this.socketReader, n);
            this.print("...failed because: " + string + "\n");
            System.out.println("An error occured while connecting to client.");
            System.out.println(string);
            System.exit(-1);
        }
    }

    public Counts getCounts() {
        return this.counts;
    }

    private void print(String string) {
        if (this.verbose) {
            System.out.print(string);
        }
    }

    public static byte[] readTable(Parse parse) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        Parse parse2 = parse.more;
        parse.more = null;
        if (parse.trailer == null) {
            parse.trailer = "";
        }
        parse.print(printWriter);
        parse.more = parse2;
        printWriter.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void writeCounts(Counts counts) throws IOException {
        FitProtocol.writeCounts(this.counts, this.socketOutput);
    }

    class TablePrintingFixtureListener
    implements FixtureListener {
        TablePrintingFixtureListener() {
        }

        public void tableFinished(Parse parse) {
            try {
                byte[] byArray = FitServer.readTable(parse);
                if (byArray.length > 0) {
                    FitProtocol.writeData(byArray, FitServer.this.socketOutput);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void tablesFinished(Counts counts) {
            try {
                FitProtocol.writeCounts(counts, FitServer.this.socketOutput);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

