/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Binding;
import fit.Fixture;
import fit.Parse;
import fit.TypeAdapter;

public class ColumnFixture
extends Fixture {
    protected Binding[] columnBindings;
    protected boolean hasExecuted = false;

    public void doRows(Parse parse) {
        this.bind(parse.parts);
        super.doRows(parse.more);
    }

    public void doRow(Parse parse) {
        this.hasExecuted = false;
        try {
            this.reset();
            super.doRow(parse);
            if (!this.hasExecuted) {
                this.execute();
            }
        }
        catch (Exception exception) {
            this.exception(parse.leaf(), exception);
        }
    }

    public void doCell(Parse parse, int n) {
        try {
            this.columnBindings[n].doCell(this, parse);
        }
        catch (Throwable throwable) {
            this.exception(parse, throwable);
        }
    }

    public void check(Parse parse, TypeAdapter typeAdapter) {
        try {
            this.executeIfNeeded();
        }
        catch (Exception exception) {
            this.exception(parse, exception);
        }
        super.check(parse, typeAdapter);
    }

    protected void executeIfNeeded() throws Exception {
        if (!this.hasExecuted) {
            this.hasExecuted = true;
            this.execute();
        }
    }

    public void reset() throws Exception {
    }

    public void execute() throws Exception {
    }

    protected void bind(Parse parse) {
        try {
            this.columnBindings = new Binding[parse.size()];
            int n = 0;
            while (parse != null) {
                this.columnBindings[n] = this.createBinding(n, parse);
                ++n;
                parse = parse.more;
            }
        }
        catch (Throwable throwable) {
            this.exception(parse, throwable);
        }
    }

    protected Binding createBinding(int n, Parse parse) throws Throwable {
        return Binding.create(this, parse.text());
    }
}

