/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.ColumnFixture;
import fit.Fixture;
import fit.GracefulNamer;
import fit.Parse;
import fit.TypeAdapter;
import fit.exception.FitFailureException;
import fit.exception.NoSuchFieldFitFailureException;
import fit.exception.NoSuchMethodFitFailureException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Binding {
    private static Pattern methodPattern = Pattern.compile("(.+)(?:\\(\\)|\\?|!)");
    private static Pattern fieldPattern = Pattern.compile("=?([^=]+)=?");
    public TypeAdapter adapter;

    public static Binding create(Fixture fixture, String string) throws Throwable {
        Binding binding = null;
        if (string.startsWith("=")) {
            binding = new SaveBinding();
        } else if (string.endsWith("=")) {
            binding = new RecallBinding();
        } else if (methodPattern.matcher(string).matches()) {
            binding = new QueryBinding();
        } else if (fieldPattern.matcher(string).matches()) {
            binding = new SetBinding();
        }
        if (binding == null) {
            binding = new NullBinding();
        } else {
            binding.adapter = Binding.makeAdapter(fixture, string);
        }
        return binding;
    }

    private static TypeAdapter makeAdapter(Fixture fixture, String string) throws Throwable {
        Matcher matcher = methodPattern.matcher(string);
        if (matcher.find()) {
            return Binding.makeAdapterForMethod(string, fixture, matcher);
        }
        return Binding.makeAdapterForField(string, fixture);
    }

    private static TypeAdapter makeAdapterForField(String string, Fixture fixture) {
        Field field = null;
        if (GracefulNamer.isGracefulName(string)) {
            String string2 = GracefulNamer.disgrace(string).toLowerCase();
            field = Binding.findField(fixture, string2);
        } else {
            try {
                Matcher matcher = fieldPattern.matcher(string);
                matcher.find();
                String string3 = matcher.group(1);
                field = fixture.getTargetClass().getField(string3);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (field == null) {
            throw new NoSuchFieldFitFailureException(string);
        }
        return TypeAdapter.on(fixture, field);
    }

    private static TypeAdapter makeAdapterForMethod(String string, Fixture fixture, Matcher matcher) {
        Method method = null;
        if (GracefulNamer.isGracefulName(string)) {
            String string2 = GracefulNamer.disgrace(string).toLowerCase();
            method = Binding.findMethod(fixture, string2);
        } else {
            try {
                String string3 = matcher.group(1);
                method = fixture.getTargetClass().getMethod(string3, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (method == null) {
            throw new NoSuchMethodFitFailureException(string);
        }
        return TypeAdapter.on(fixture, method);
    }

    private static Field findField(Fixture fixture, String string) {
        Field[] fieldArray = fixture.getTargetClass().getFields();
        Field field = null;
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field2 = fieldArray[i];
            if (!string.equals(field2.getName().toLowerCase())) continue;
            field = field2;
            break;
        }
        return field;
    }

    private static Method findMethod(Fixture fixture, String string) {
        Method[] methodArray = fixture.getTargetClass().getMethods();
        Method method = null;
        for (int i = 0; i < methodArray.length; ++i) {
            Method method2 = methodArray[i];
            if (!string.equals(method2.getName().toLowerCase())) continue;
            method = method2;
            break;
        }
        return method;
    }

    public abstract void doCell(Fixture var1, Parse var2) throws Throwable;

    public static class NullBinding
    extends Binding {
        public void doCell(Fixture fixture, Parse parse) {
            fixture.ignore(parse);
        }
    }

    public static class QueryBinding
    extends Binding {
        public void doCell(Fixture fixture, Parse parse) {
            fixture.check(parse, this.adapter);
        }
    }

    public static class SetBinding
    extends Binding {
        public void doCell(Fixture fixture, Parse parse) throws Throwable {
            if ("".equals(parse.text())) {
                fixture.handleBlankCell(parse, this.adapter);
            }
            this.adapter.set(this.adapter.parse(parse.text()));
        }
    }

    public static class RecallBinding
    extends Binding {
        public void doCell(Fixture fixture, Parse parse) throws Exception {
            String string = parse.text();
            String string2 = (String)Fixture.getSymbol(string);
            if (string2 == null) {
                fixture.exception(parse, new FitFailureException("No such symbol: " + string));
            } else {
                this.adapter.set(this.adapter.parse(string2));
            }
        }
    }

    public static class SaveBinding
    extends Binding {
        public void doCell(Fixture fixture, Parse parse) {
            try {
                if (fixture instanceof ColumnFixture) {
                    ((ColumnFixture)fixture).executeIfNeeded();
                }
                String string = this.adapter.get().toString();
                String string2 = parse.text();
                Fixture.setSymbol(string2, string);
                parse.addToBody(Fixture.gray(" = " + string));
            }
            catch (Exception exception) {
                fixture.exception(parse, exception);
            }
        }
    }
}

