/*
 * Decompiled with CFR 0.152.
 */
package eg.bowling.fixtures;

import eg.bowling.Bowling;
import eg.bowling.BowlingGame;
import fitnesse.fixtures.TableFixture;

public class ScoreGame
extends TableFixture {
    private Bowling game;
    public static final int STRIKE = -1;
    public static final int SPARE = -2;
    public static final int BLANK = -3;
    public static final int ERROR = -4;

    protected void doStaticTable(int n) {
        this.game = new BowlingGame();
        this.doRolls();
        this.doScores();
    }

    private void doRolls() {
        for (int i = 0; i < 21; ++i) {
            int n = this.parseRoll(i);
            if (n == -2) {
                this.spare(i);
                continue;
            }
            if (n == -1) {
                this.strike(i);
                continue;
            }
            if (n == -3) {
                this.blank(i);
                continue;
            }
            if (n == -4) {
                this.wrongRoll(i);
                continue;
            }
            this.roll(n);
        }
    }

    private int parseRoll(int n) {
        String string = this.getText(1, n);
        if (string.equals("/")) {
            return -2;
        }
        if (string.equals("X")) {
            return -1;
        }
        if (string.equals("")) {
            return -3;
        }
        try {
            int n2 = Integer.parseInt(string);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return -4;
        }
    }

    private void spare(int n) {
        if (this.odd(n)) {
            this.wrongRoll(n);
        } else {
            int n2 = this.parseRoll(n - 1);
            if (n2 < 0) {
                this.wrongRoll(n);
            } else {
                this.roll(10 - n2);
            }
        }
    }

    private void wrongRoll(int n) {
        this.wrong(1, n);
    }

    private void strike(int n) {
        if (n == 18) {
            this.roll(10);
        } else if (n == 19 && this.parseRoll(18) == -1) {
            this.roll(10);
        } else if (n == 20 && (this.parseRoll(19) == -1 || this.parseRoll(19) == -2)) {
            this.roll(10);
        } else if (this.odd(n)) {
            this.wrongRoll(n);
        } else {
            int n2 = this.parseRoll(n - 1);
            if (n2 != -3) {
                this.wrongRoll(n);
            } else {
                this.roll(10);
            }
        }
    }

    private boolean odd(int n) {
        return n % 2 != 1;
    }

    private void blank(int n) {
        if (n == 20 && this.parseRoll(19) != -2 && this.parseRoll(18) != -1) {
            return;
        }
        if (this.parseRoll(n + 1) == -1) {
            return;
        }
        this.wrongRoll(n);
    }

    private void roll(int n) {
        this.game.roll(n);
    }

    private void doScores() {
        for (int i = 0; i < 10; ++i) {
            int n;
            int n2 = this.getScore(i);
            if (n2 == (n = this.game.score(i + 1))) {
                this.rightScore(i);
                continue;
            }
            this.wrongScore(i, "" + n);
        }
    }

    private void rightScore(int n) {
        this.right(2, this.scoreIndex(n));
    }

    private void wrongScore(int n, String string) {
        this.wrong(2, this.scoreIndex(n), string);
    }

    private int getScore(int n) {
        return Integer.parseInt(this.getText(2, this.scoreIndex(n)));
    }

    private int scoreIndex(int n) {
        return n * 2 + 1;
    }
}

