/******************************************************************************/
/* based on satx.c, special treatment when there is few strongly constrained  
*/
/* variables                                                                  
*/
/*                                                                            
*/
/*                    Author: Chu Min LI (cli@laria.u-picardie.fr)            
*/
/*                    Copyright LaRIA, Universite de Picardie Jules Verne     
*/
/*                    September 1996                                          
*/
/******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/times.h>
#include <sys/types.h>
#include <limits.h>

typedef signed char my_type;
typedef unsigned char my_unsigned_type;

#define DYNAMIQUE_SIZE 256
#define WORD_LENGTH 50
#define TRUE 1
#define FALSE 0
#define NONE -1

#define WEIGTH 5
#define T 10

/* the tables of variables and clauses are statically allocated. Modify the 
   parameters tab_variable_size and tab_clause_size before compilation if 
   necessary */
#define tab_variable_size  5000
#define tab_variable_size_plus_1 tab_variable_size+1
#define tab_clause_size 100000
#define tab_clause_size_plus_1 tab_clause_size+1
#define tab_literal_size 2*tab_variable_size
#define double_tab_clause_size 2*tab_clause_size
#define positive(literal) literal<NB_VAR
#define negative(literal) literal>=NB_VAR
#define get_var_from_lit(negative_literal) negative_literal-NB_VAR
#define RESOLVANT_LENGTH 3
#define RESOLVANT_SEARCH_THRESHOLD 5000
#define complement(lit1, lit2) ((lit1<lit2) ? lit2-lit1 == NB_VAR : lit1-lit2 == NB_VAR)

#define pop(stack) stack[--stack ## _fill_pointer]
#define push(item, stack) stack[stack ## _fill_pointer++] = item
#define unit_clause(clause) clause_length[clause] == 1

#define dolist(ppointer, pend, begin, end)                                  \
          for(ppointer = begin, pend = end; ppointer != pend; ppointer++)


#define empty_vector(pstack) pstack ## _fill_pointer == 0

#define satisfiable() CLAUSE_STACK_fill_pointer == NB_CLAUSE

#define NEGATIVE 0
#define POSITIVE 1
#define PASSIVE 0
#define ACTIVE 1
#define MAX_NODE_NUMBER 6000

struct node {
    int clause;
    struct node *next;
};

struct ressource {
     struct node *pnode;
     struct ressource *next;
};

int CLAUSE_NODES_pointer=MAX_NODE_NUMBER;

struct node *CLAUSE_NODES;
struct ressource *ressources=NULL;

struct node *allocate_node() {
   struct ressource *pressource;
   if (CLAUSE_NODES_pointer == MAX_NODE_NUMBER) {
      CLAUSE_NODES = (struct node *)malloc(MAX_NODE_NUMBER * sizeof(struct 
node));
      CLAUSE_NODES_pointer = 0;
      pressource= (struct ressource *)malloc(sizeof (struct ressource));
      pressource->next = ressources;
      ressources=pressource;
      pressource->pnode = CLAUSE_NODES;
   }  
   return &(CLAUSE_NODES[CLAUSE_NODES_pointer++]);
}

void free_ressources() {
   struct ressource *pressource;
   while (ressources != NULL) {
      free(ressources->pnode);
      pressource = ressources;
      ressources = ressources->next;
      free(pressource);
   }
}

struct node *node_neg_in[tab_variable_size];
struct node *node_pos_in[tab_variable_size];

int *neg_in[tab_variable_size];
int *pos_in[tab_variable_size];
my_unsigned_type neg_nb[tab_variable_size];
my_unsigned_type pos_nb[tab_variable_size];
my_type var_current_value[tab_variable_size];
my_type var_rest_value[tab_variable_size];
my_type var_state[tab_variable_size];

int saved_clause_stack[tab_variable_size];
int saved_managedclause_stack[tab_variable_size];
my_unsigned_type nb_neg_clause_of_length2[tab_variable_size];
my_unsigned_type nb_neg_clause_of_length3[tab_variable_size];
my_unsigned_type nb_pos_clause_of_length2[tab_variable_size];
my_unsigned_type nb_pos_clause_of_length3[tab_variable_size];

/* int reduce_if_positive[tab_variable_size][DYNAMIQUE_SIZE];
int reduce_if_negative[tab_variable_size][DYNAMIQUE_SIZE];
*/
int reduce_if_negative_nb[tab_variable_size];
int reduce_if_positive_nb[tab_variable_size];

int *sat[tab_clause_size];
my_type clause_state[tab_clause_size];
my_type clause_length[tab_clause_size];
/* my_type static_clause_length[tab_clause_size]; */

int VARIABLE_STACK_fill_pointer = 0;
int CLAUSE_STACK_fill_pointer = 0;
int UNITCLAUSE_STACK_fill_pointer = 0;
int MANAGEDCLAUSE_STACK_fill_pointer = 0;
int IMPLIED_LITS_fill_pointer=0;

int VARIABLE_STACK[tab_variable_size];
int CLAUSE_STACK[tab_clause_size];
int UNITCLAUSE_STACK[tab_clause_size];
int MANAGEDCLAUSE_STACK[double_tab_clause_size];
int IMPLIED_LITS[tab_variable_size];

int MY_VARIABLE_STACK[tab_variable_size];
int MY_CLAUSE_STACK[tab_clause_size];
int MY_UNITCLAUSE_STACK[tab_clause_size];
int MY_MANAGEDCLAUSE_STACK[double_tab_clause_size];

int TESTED_VAR_STACK[tab_variable_size];
int TESTED_VAR_STACK_fill_pointer=0;

int NB_VAR;
int NB_CLAUSE;
int INIT_NB_CLAUSE;
my_type R = 3;

long NB_UNIT=0, NB_MONO=0, NB_BRANCHE=0, NB_BACK = 0;

my_type MAYBE_SATISFIABLE = TRUE;

int MY_VARIABLE_STACK_fill_pointer = 0;
int MY_CLAUSE_STACK_fill_pointer = 0;
int MY_UNITCLAUSE_STACK_fill_pointer = 0;
int MY_MANAGEDCLAUSE_STACK_fill_pointer = 0;

void remove_clauses(int *clauses) {
   int clause;
   for(clause=*clauses; clause!=NONE; clause=*(++clauses)) {
     if (clause_state[clause] == ACTIVE) {
        clause_state[clause] = PASSIVE;
        push(clause, CLAUSE_STACK);
     }
  }
}

int manage_clauses(register int *clauses) {
   int clause;
   for(clause=*clauses; clause!=NONE; clause=*(++clauses)) {
      if (clause_state[clause] == ACTIVE) {
         switch (clause_length[clause]) {
            case 1: return FALSE;
            case 2: push(clause, UNITCLAUSE_STACK);
                    clause_length[clause]--; break;
            default: clause_length[clause]--;
                     push(clause, MANAGEDCLAUSE_STACK);
         }
      }
   }
   return TRUE;
}

void simple_manage_clauses(register int *clauses) {
   int clause;
   for(clause=*clauses; clause!=NONE; clause=*(++clauses)) { 
     if (clause_state[clause] == ACTIVE) {
         switch (clause_length[clause]) {
            case 2: push(clause, UNITCLAUSE_STACK);
                    clause_length[clause]--; break;
            default: clause_length[clause]--;
                     push(clause, MANAGEDCLAUSE_STACK);
         }
      }
   }
}

void my_simple_manage_clauses(register int *clauses) {
   int clause;
   for(clause=*clauses; clause!=NONE; clause=*(++clauses)) { 
      if (clause_state[clause] == ACTIVE) { 
         switch (clause_length[clause]) {
            case 2: push(clause, MY_UNITCLAUSE_STACK);
                    clause_length[clause]--; break;
            default: clause_length[clause]--; 
                     push(clause, MY_MANAGEDCLAUSE_STACK);
         }
      }
   }
}

int my_manage_clauses(register int *clauses) {
   int clause;
   for(clause=*clauses; clause!=NONE; clause=*(++clauses)) {
      if (clause_state[clause] == ACTIVE) { 
         switch (clause_length[clause]) {
            case 1: return FALSE;
            case 2: push(clause, MY_UNITCLAUSE_STACK);
                    clause_length[clause]--; break;
            default: clause_length[clause]--;
                     push(clause, MY_MANAGEDCLAUSE_STACK);
         }
      }
   }
   return TRUE;
}                                                             

void print_values(int nb_var, char *input_file) {
    FILE* fp_out; char output_file_name[WORD_LENGTH];
    int i;
    fp_out = fopen("satx.sol", "w");
    for (i=0; i<nb_var; i++) {
       if (var_current_value[i] == 1) 
          fprintf(fp_out, "%d ", i+1);
       else
          fprintf(fp_out, "%d ", 0-i-1);
    }
    fprintf(fp_out, "\n");
    fclose(fp_out);			
} 

int backtracking() {
   int var, index;
      
   UNITCLAUSE_STACK_fill_pointer = 0;
   NB_BACK++;

   do {
      var = pop(VARIABLE_STACK);
      if (var_rest_value[var] == NONE) 
          var_state[var] = ACTIVE;
      else {
          for (index = saved_clause_stack[var]; 
               index < CLAUSE_STACK_fill_pointer;
               index++)
             clause_state[CLAUSE_STACK[index]] = ACTIVE;
          CLAUSE_STACK_fill_pointer = saved_clause_stack[var];

          for (index = saved_managedclause_stack[var];
               index < MANAGEDCLAUSE_STACK_fill_pointer;
               index++)
             clause_length[MANAGEDCLAUSE_STACK[index]]++;
          MANAGEDCLAUSE_STACK_fill_pointer = saved_managedclause_stack[var];

          var_current_value[var] = var_rest_value[var];
          var_rest_value[var] = NONE;
          push(var, VARIABLE_STACK);
          if (var_current_value[var]==FALSE) {
            simple_manage_clauses(pos_in[var]);
            remove_clauses(neg_in[var]);
          }
          else {
            simple_manage_clauses(neg_in[var]);
            remove_clauses(pos_in[var]);
          }
          return TRUE;
      }
   } while (VARIABLE_STACK_fill_pointer != 0);
   return FALSE;
}


/* test if the new clause is redundant or subsompted by another */
#define OLD_CLAUSE_REDUNDANT 77
#define NEW_CLAUSE_REDUNDANT 7

int smaller_than(int lit1, int lit2) {
    return ((lit1<NB_VAR) ? lit1 : lit1-NB_VAR) < ((lit2<NB_VAR) ? lit2 : 
lit2-NB_VAR);
}

my_type redundant(int *new_clause, int *old_clause) {
    int i, j1=0, j2=0, lit1, lit2, old_clause_diff=0, new_clause_diff=0;
    
    while (((lit1=old_clause[j1]) != NONE) && ((lit2=new_clause[j2]) != NONE)) 
{
       if (smaller_than(lit1, lit2)) {
          j1++; old_clause_diff++;
       }
       else
       if (smaller_than(lit2, lit1)) {
          j2++; new_clause_diff++;
       }
       else
       if (complement(lit1, lit2)) {
           return FALSE; /* old_clause_diff++; new_clause_diff++; j1++; j2++; 
*/
       }
       else {
          j1++; j2++;
       }
    }
    if ((lit1 == NONE) && (old_clause_diff == 0))
   /* la nouvelle clause est redondante ou subsumee */
       return NEW_CLAUSE_REDUNDANT;
    if ((lit2 == NONE) && (new_clause_diff == 0))
         /* la old clause est redondante ou subsumee */
       return OLD_CLAUSE_REDUNDANT;
    return FALSE;
}

my_type get_resolvant(int *clause1, int *clause2, int *resolvant) {
    int lit1, lit2, nb_diff=0, nb_iden=0, nb_opps=0, j1=0, j2=0, j, 
limited_length;

    while (((lit1=clause1[j1])!=NONE) && ((lit2=clause2[j2]) != NONE)) {
       if (complement(lit1, lit2)) {
          j1++; j2++; nb_opps++;
       }
       else
       if (lit1 == lit2) {
          j1++; j2++; nb_iden++;
       }
       else
       if (smaller_than(lit1, lit2)) {
          nb_diff++; j1++;
       }
       else {
          nb_diff++; j2++;
       }
    }
    if (nb_opps ==1) {
       if (clause1[j1] ==NONE) {
          for (; clause2[j2]!= NONE; j2++) nb_diff++;
       }
       else {
          for (; clause1[j1]!= NONE; j1++) nb_diff++;
       }
       if ((j1==1) || (j2==1))  limited_length=RESOLVANT_LENGTH; 
       else
       if ((j1==2) && (j2==2))  limited_length=1;
       else
       if (j1<j2) limited_length=((j1<RESOLVANT_LENGTH) ? j1 : 
RESOLVANT_LENGTH);
       else  limited_length=((j2<RESOLVANT_LENGTH) ? j2 : RESOLVANT_LENGTH);

       if (nb_diff + nb_iden <= limited_length) {
          j1=0; j2=0; j=0;
          while (((lit1 = clause1[j1])!=NONE) && ((lit2 = clause2[j2]) != 
NONE)) {
             if (lit1 == lit2) {
                resolvant[j] = lit1; j1++; j2++; j++;
             }
             else 
             if (smaller_than(lit1, lit2)) {
                resolvant[j] = lit1; j1++; j++;
             }
             else
             if (smaller_than(lit2, lit1)) {
                resolvant[j] = lit2; j2++; j++;
             }
             else {
                j1++; j2++;
             }
          }
          if (clause1[j1] ==NONE) while ((resolvant[j++] = clause2[j2++]) != 
NONE);
          else while ((resolvant[j++] = clause1[j1++]) != NONE);
          return TRUE;
       }
    }
    return FALSE;
}

void remove_link(int clause) {
   int lit;
   int *lits;
   struct node *pnode1, *pnode2, *pnode;

   lits = sat[clause];

   for (lit=*lits; lit != NONE; lit=*(++lits)) { 
       pnode = (positive(lit) ? node_pos_in[lit] : 
                                node_neg_in[get_var_from_lit(lit)]);
       if (pnode == NULL) return;
       if (pnode->clause == clause) {
          if (positive(lit)) node_pos_in[lit] = pnode->next;
          else node_neg_in[get_var_from_lit(lit)] = pnode->next;
       }
       else
       for (pnode1 = pnode, pnode2 = pnode->next;
            pnode2 != NULL; pnode2=pnode2->next) {
         if (pnode2->clause == clause) {
            pnode1->next = pnode2->next;
            break;
         }
         else
            pnode1 = pnode2;
       }
   }
}

void set_link(int clause) {
   int lit;
   int *lits;
   struct node *pnode1, *pnode2, *pnode;

   lits = sat[clause];
   for (lit=*lits; lit != NONE; lit=*(++lits)) { 
       pnode = allocate_node();
       pnode->clause = clause;
       if (positive(lit)) {
          pnode->next = node_pos_in[lit];
          node_pos_in[lit] = pnode;
       }
       else {
          pnode->next = node_neg_in[get_var_from_lit(lit)];
          node_neg_in[get_var_from_lit(lit)] = pnode;
       }
   }
}

int search_redundence(int *lits) {
   int i, lit, is_red;
   int *old_lits, *new_lits;
   struct node *pnode;

   new_lits = lits;
   for (lit=*lits; lit != NONE; lit=*(++lits)) { 
     for (pnode = (positive(lit) ? node_pos_in[lit] : 
                                   node_neg_in[get_var_from_lit(lit)]);
          pnode != NULL; pnode = pnode->next) {
       old_lits = sat[pnode->clause];
       is_red = redundant(new_lits, old_lits);
       if (is_red == OLD_CLAUSE_REDUNDANT) {
/*          printf("old clause %d is redundant\n", 
                 pnode->clause);
*/
          clause_state[pnode->clause] = PASSIVE;
          remove_link(pnode->clause);
       }
       else
       if (is_red == NEW_CLAUSE_REDUNDANT) {
          return NEW_CLAUSE_REDUNDANT;
       }
     }
  }
  return FALSE;  
}

int add_resolvant(int *lits) {
   int i, j, lit, is_red, resolvant[RESOLVANT_LENGTH+1];
   my_type is_res;
   int *old_lits, *new_lits, *res;
   struct node *pnode;

   new_lits = lits;
   for (lit=*lits; lit != NONE; lit=*(++lits))
     for (pnode = (positive(lit) ?
                  node_neg_in[lit] :
                  node_pos_in[get_var_from_lit(lit)]);
          pnode != NULL; pnode = pnode->next) {
        old_lits = sat[pnode->clause];
        is_res = get_resolvant(new_lits, old_lits, resolvant);
        if (is_res != FALSE) {
          is_red=search_redundence(resolvant);
          if (is_red != NEW_CLAUSE_REDUNDANT) {
             res=(int *)malloc((RESOLVANT_LENGTH+1)*sizeof(int));
             clause_state[NB_CLAUSE]=ACTIVE;      
             j=0;
             while ((res[j]=resolvant[j]) != NONE) ++j;
             if (j==0) return NONE;
             sat[NB_CLAUSE] = res; clause_length[NB_CLAUSE++]=j;
          }
        }
      }
   return TRUE;
}

int* copy_clauses(struct node *node_in) {
    int j=0, *in; struct node *pnode;

    pnode=node_in;
    while (pnode != NULL) {
      j++; pnode = pnode->next;
    }
    in = (int *)malloc((j+1)*sizeof(int));
    j=0; pnode=node_in; 
    while (pnode != NULL) {
        in[j] = pnode->clause; j++; pnode = pnode->next; 
    }
    in[j] = NONE;
    return in;
}
   
my_type build_sat_instance(char *input_file) {
   FILE* fp_in=fopen(input_file, "r");
   char ch, tautologie, word1[WORD_LENGTH], word2[WORD_LENGTH];
   int endln, germe, i, j, index, length, ii, jj, lit1, is_red,
       lits[tab_variable_size], *plit, *lits1, lit, var, *clause,
       NB_CLAUSE1;

   if (fp_in==NULL) return FALSE;

   fscanf(fp_in, "%c", &ch);
  while (ch!='p') {
    while (ch!='\n') fscanf(fp_in, "%c", &ch);  
    fscanf(fp_in, "%c", &ch);
  }
  
   fscanf(fp_in, "%s%d%d", word2, &NB_VAR, &NB_CLAUSE);

   for (i=0; i<NB_CLAUSE; i++) {
      length=0; 
      fscanf(fp_in, "%d", &lits[length]);
      while (lits[length] != 0) {
        length++;
        fscanf(fp_in, "%d", &lits[length]);
      }
      tautologie = FALSE;
      /* test if some literals are redundant and sort the clause */
      for (ii=0; ii<length-1; ii++) {
         lit = lits[ii];
         for (jj=ii+1; jj<length; jj++) {
            if (abs(lit)>abs(lits[jj])) {
               lit1=lits[jj]; lits[jj]=lit; lit=lit1;
            }
            else
            if (lit == lits[jj]) {
               lits[jj--] = lits[--length]; lits[length] = 0;
               printf("literal %d is redundant in clause %d\n", lit, i);
            }
            else
            if (abs(lit) == lits[jj]) {
               tautologie = TRUE; break;
            }
         }
         if (tautologie == TRUE) break;
         else lits[ii] = lit;
      }              
      if (tautologie == FALSE) {     
        lits[length] = 0;
        sat[i] = (int *)malloc((length+1)*sizeof(int));
        j=0;
        while (lits[j] != 0) { 
           if (lits[j] > 0) sat[i][j] = lits[j]-1;
           else sat[i][j] = abs(lits[j]) + NB_VAR -1;
           j++;
        }
        sat[i][j] = NONE;
        clause_length[i] = length;
        clause_state[i] = ACTIVE;
 /*       static_clause_length[i] = length;
*/
      }
      else i--;
   }
   fclose(fp_in);

   for (i=0; i<NB_VAR; i++) {
      node_neg_in[i] = NULL;
      node_pos_in[i] = NULL;
      var_state[i]=ACTIVE;
   }

   INIT_NB_CLAUSE= NB_CLAUSE;
  
   for(i=0; i<NB_CLAUSE; i++) {
      plit = sat[i];
      length = clause_length[i];          
      if (length==1) push(i, UNITCLAUSE_STACK);
      if (search_redundence(plit) != NEW_CLAUSE_REDUNDANT) {
         if (add_resolvant(plit) == NONE) return NONE;
         else set_link(i);

      }
      else clause_state[i] = PASSIVE;
   }
   NB_CLAUSE1 = 0;
   for (i=0; i<NB_CLAUSE; i++) {
     if (clause_state[i] == ACTIVE) NB_CLAUSE1++;
   }
   NB_CLAUSE = NB_CLAUSE1;

   for(i=0; i<NB_VAR; i++) {
      neg_in[i]=copy_clauses(node_neg_in[i]);
      pos_in[i]=copy_clauses(node_pos_in[i]);
   }
   free_ressources();
   return TRUE;
}

my_type build_simple_sat_instance(char *input_file) {
   FILE* fp_in=fopen(input_file, "r");
   char ch, word1[WORD_LENGTH], word2[WORD_LENGTH];
   int endln, i, j, index, length, 
       lits[tab_variable_size], *lits1, lit, var;

   if (fp_in == NULL) return FALSE;

   fscanf(fp_in, "%c", &ch);
  while (ch!='p') {
    while (ch!='\n') fscanf(fp_in, "%c", &ch);  
    fscanf(fp_in, "%c", &ch);
  }
  
   fscanf(fp_in, "%s%d%d", word2, &NB_VAR, &NB_CLAUSE);
   INIT_NB_CLAUSE = NB_CLAUSE;
      
   for (i=0; i<NB_VAR; i++) {
       nb_neg_clause_of_length3[i] = 0;
       nb_pos_clause_of_length3[i] = 0;
       nb_neg_clause_of_length2[i] = 0;
       nb_pos_clause_of_length2[i] = 0;
       neg_nb[i] = 0;
       pos_nb[i] = 0;
   }
   for (i=0; i<NB_CLAUSE; i++) {
      length=0; 
      fscanf(fp_in, "%d", &lits[length]);
      while (lits[length] != 0) {
        length++;
        fscanf(fp_in, "%d", &lits[length]);
      }
      sat[i]= (int *)malloc((length+1) * sizeof(int));
      for (j=0; j<length; j++) {
	if (lits[j] < 0) {
           var=abs(lits[j]) - 1;
           if (length==3)
              nb_neg_clause_of_length3[var]++;
           else
           if (length==2)
              nb_neg_clause_of_length2[var]++;
           else
           if (length==1)
              push(i, UNITCLAUSE_STACK);
           neg_nb[var]++;
           sat[i][j] = var + NB_VAR ;
        }
        else {
           sat[i][j] = lits[j]-1;
           pos_nb[sat[i][j]]++;
           if (length==3)
              nb_pos_clause_of_length3[sat[i][j]]++;
           else
           if (length==2)
              nb_pos_clause_of_length2[sat[i][j]]++;
           else
           if (length==1)
              push(i, UNITCLAUSE_STACK);
        }
      }
      clause_length[i]=length;
      clause_state[i] = ACTIVE;
      sat[i][length]=NONE;
   }
   fclose(fp_in);
 
   for (i=0; i<NB_VAR; i++) { 

      neg_in[i] = (int *)
	          malloc((neg_nb[i]+1) * sizeof(int));
      pos_in[i] = (int *)
	          malloc((pos_nb[i]+1) * sizeof(int));
      neg_in[i][neg_nb[i]]=NONE;
      pos_in[i][pos_nb[i]]=NONE;
      neg_nb[i] = 0;
      pos_nb[i] = 0;
      var_state[i] = ACTIVE;
   }   
   for (i=0; i<NB_CLAUSE; i++) {
      lits1 = sat[i];
      for(lit=*lits1; lit!=NONE; lit=*(++lits1)) {
	 if (positive(lit)) 
            pos_in[lit][pos_nb[lit]++] = i;
	 else
            neg_in[get_var_from_lit(lit)]
                  [neg_nb[get_var_from_lit(lit)]++] = i;
      }
   }
   return TRUE;
}

int verify_solution() {
   int i, j, lit, *lits, clause_truth;

   for (i=0; i<NB_CLAUSE; i++) {
      clause_truth = FALSE;
      lits = sat[i];
      for(lit=*lits; lit!=NONE; lit=*(++lits))
         if (((negative(lit)) && 
              (var_current_value[get_var_from_lit(lit)] == FALSE)) ||
             ((positive(lit)) && 
              (var_current_value[lit] == TRUE)) ) {
            clause_truth = TRUE;
            break;
         }
      if (clause_truth == FALSE) return FALSE;
   }

   return TRUE;
}

long NB_SEARCH = 0; long NB_FIXED = 0;
  
void unitclause_process() {
  int var, i, j, unitclause, clause, lit, *lits, unitclause_position;
  
  for (unitclause_position = 0; 
       unitclause_position < UNITCLAUSE_STACK_fill_pointer;
       unitclause_position++) {
     unitclause = UNITCLAUSE_STACK[unitclause_position];
     clause_length[unitclause]++;
     if (clause_state[unitclause] == ACTIVE) {
       NB_UNIT++;
       lits = sat[unitclause];
       for(lit=*lits; lit!=NONE; lit=*(++lits)) {
          if (positive(lit)) {
             var = lit;
             if (var_state[var] == ACTIVE) {
                var_current_value[var] = TRUE;
                var_rest_value[var] = NONE;
                if (manage_clauses(neg_in[var])==TRUE) {
                   var_state[var] = PASSIVE;
                   push(var, VARIABLE_STACK);
                   remove_clauses(pos_in[var]);
                   break;
                }
                else {
                   for (i=unitclause_position+1;  
                        i<UNITCLAUSE_STACK_fill_pointer; i++)
                      clause_length[UNITCLAUSE_STACK[i]]++;
                   backtracking();
                   return;
                }
             }
          }
          else {
             var = get_var_from_lit(lit);
             if (var_state[var] == ACTIVE) {
                var_current_value[var] = FALSE;
                var_rest_value[var] = NONE;
                if (manage_clauses(pos_in[var])== TRUE) {
                   var_state[var] = PASSIVE;
                   push(var, VARIABLE_STACK);
                   remove_clauses(neg_in[var]);
                    break;
                }
                else {
                   for (i=unitclause_position+1;  
                        i<UNITCLAUSE_STACK_fill_pointer; i++)
                      clause_length[UNITCLAUSE_STACK[i]]++;
                   backtracking();
                   return;
                }
             }
          }
       }     
     }
   }
   UNITCLAUSE_STACK_fill_pointer = 0;
}

int get_nb_clauses(int var) {
   return ((nb_neg_clause_of_length2[var] + 
            nb_pos_clause_of_length2[var]) * WEIGTH) + 
           nb_neg_clause_of_length3[var] + 
           nb_pos_clause_of_length3[var];
}

int get_resolvant_nb(int clause) {
  int *lits;
  int lit, var, i, resolvant_nb=0;
       
  lits = sat[clause];
  for(lit=*lits; lit!=NONE; lit=*(++lits)) {
     if (positive(lit)) {
        var = lit;
        if (var_state[var] == ACTIVE)
          resolvant_nb += (nb_neg_clause_of_length2[var] * WEIGTH)+ 
                           nb_neg_clause_of_length3[var];
     }
     else {
        var = get_var_from_lit(lit);
        if (var_state[var] == ACTIVE) 
           resolvant_nb += (nb_pos_clause_of_length2[var] * WEIGTH)+ 
                           nb_pos_clause_of_length3[var];
     }
  }
  return resolvant_nb;
}

void reset_context() {
   int i, tested_var;

   MY_UNITCLAUSE_STACK_fill_pointer = 0;

   for (i=0; i<MY_VARIABLE_STACK_fill_pointer; i++)
       var_state[MY_VARIABLE_STACK[i]] = ACTIVE;
   MY_VARIABLE_STACK_fill_pointer = 0;

   for (i=0; i<MY_MANAGEDCLAUSE_STACK_fill_pointer; i++)
         clause_length[MY_MANAGEDCLAUSE_STACK[i]]++;
   MY_MANAGEDCLAUSE_STACK_fill_pointer = 0;  

}

int examine1(int tested_var) {
   int i, generating_fixed_variables_if_positif = 0, 
          generating_fixed_variables_if_negatif = 0,
          nb_clause_if_positif, nb_clause_if_negatif,
          clause, var;
   
      var_current_value[tested_var] = TRUE;

      var_state[tested_var] = PASSIVE;
      push(tested_var, MY_VARIABLE_STACK);
      my_simple_manage_clauses(neg_in[tested_var]);

      generating_fixed_variables_if_positif = branch();
   
      if (generating_fixed_variables_if_positif == NONE) {
         reset_context();
         var_current_value[tested_var] = FALSE;
         var_rest_value[tested_var] = NONE;
         var_state[tested_var] = PASSIVE;
         push(tested_var, VARIABLE_STACK);
         simple_manage_clauses(pos_in[tested_var]);
         remove_clauses(neg_in[tested_var]); 
         return NONE;
      }
      else {
         for (i=0; i<MY_MANAGEDCLAUSE_STACK_fill_pointer; i++) {
            clause = MY_MANAGEDCLAUSE_STACK[i];
            if (clause_length[clause] == 2)
               reduce_if_positive_nb[tested_var] += get_resolvant_nb(clause);
         }
         reset_context();
      }
      var_current_value[tested_var] = FALSE;

      var_state[tested_var] = PASSIVE;
      push(tested_var, MY_VARIABLE_STACK);
      my_simple_manage_clauses(pos_in[tested_var]);

      generating_fixed_variables_if_negatif = branch();

      if (generating_fixed_variables_if_negatif == NONE) {
         reset_context();
         simple_manage_clauses(neg_in[tested_var]);
         var_current_value[tested_var] = TRUE;
         var_rest_value[tested_var] = NONE;
         var_state[tested_var] = PASSIVE;
         push(tested_var, VARIABLE_STACK);
         remove_clauses(pos_in[tested_var]);
         return NONE;
       }
       else {
         for (i=0; i<MY_MANAGEDCLAUSE_STACK_fill_pointer; i++) {
            clause = MY_MANAGEDCLAUSE_STACK[i];
            if (clause_length[clause] == 2)
               reduce_if_negative_nb[tested_var] += get_resolvant_nb(clause);
         }
         reset_context();
      }
   push(tested_var, TESTED_VAR_STACK);
   return TRUE;
}

void manage_clauses_for_propagate(register int *clauses) {
   int clause;
   for(clause=*clauses; clause!=NONE; clause=*(++clauses)) {
      if (clause_state[clause] == ACTIVE) {
         clause_length[clause]--;
         push(clause, MANAGEDCLAUSE_STACK);
      }
   }
}

int simple_propagate(int lit) {
   int var;
   if (positive(lit)) {
      var=lit;
      var_current_value[var] = TRUE;
      manage_clauses_for_propagate(neg_in[var]);
      var_rest_value[var] = NONE;
      var_state[var]=PASSIVE;
      push(var, VARIABLE_STACK);
      remove_clauses(pos_in[var]);
   }
   else {
      var=get_var_from_lit(lit);     
      var_current_value[var] = FALSE;
      manage_clauses_for_propagate(pos_in[var]);
      var_rest_value[var] = NONE;
      var_state[var]=PASSIVE;
      push(var, VARIABLE_STACK);
      remove_clauses(neg_in[var]);
   }
}

int examine(int tested_var) {
   int i, generating_fixed_variables_if_positif = 0, 
          generating_fixed_variables_if_negatif = 0,
          nb_clause_if_positif,
          nb_clause_if_negatif,
          clause, 
          var, implied_lit;
   
   IMPLIED_LITS_fill_pointer=0;   

      var_current_value[tested_var] = TRUE;

      var_state[tested_var] = PASSIVE;
      push(tested_var, MY_VARIABLE_STACK);
      my_simple_manage_clauses(neg_in[tested_var]);

      generating_fixed_variables_if_positif = branch();
      reduce_if_positive_nb[tested_var]=MY_MANAGEDCLAUSE_STACK_fill_pointer;
   
      if (generating_fixed_variables_if_positif == NONE) {
         reset_context();
         var_current_value[tested_var] = FALSE;
         var_rest_value[tested_var] = NONE;
         var_state[tested_var] = PASSIVE;
         push(tested_var, VARIABLE_STACK);
         simple_manage_clauses(pos_in[tested_var]);
         remove_clauses(neg_in[tested_var]); 
         return NONE;
      }
      else {
         for (i=0; i<MY_VARIABLE_STACK_fill_pointer; i++) {  
            var=MY_VARIABLE_STACK[i];
            if (var_current_value[var]==TRUE) implied_lit=var;
            else implied_lit=var+NB_VAR;
            push(implied_lit, IMPLIED_LITS);
         }
         reset_context();
      }
      var_current_value[tested_var] = FALSE;

      var_state[tested_var] = PASSIVE;
      push(tested_var, MY_VARIABLE_STACK);
      my_simple_manage_clauses(pos_in[tested_var]);

      generating_fixed_variables_if_negatif = branch();
      reduce_if_negative_nb[tested_var]=MY_MANAGEDCLAUSE_STACK_fill_pointer;
      reset_context();

      if (generating_fixed_variables_if_negatif == NONE) {
 /*        simple_manage_clauses(neg_in[tested_var]);
         var_current_value[tested_var] = TRUE;
         var_rest_value[tested_var] = NONE;
         var_state[tested_var] = PASSIVE;
         push(tested_var, VARIABLE_STACK);
         remove_clauses(pos_in[tested_var]);
*/
         for (i=0; i<IMPLIED_LITS_fill_pointer; i++)
             simple_propagate(IMPLIED_LITS[i]);
         return NONE;
       }
   push(tested_var, TESTED_VAR_STACK);
   return TRUE;
}

int branch() {
   int var, lit, *lits, unitclause, clause, unitclause_position, i;
  
   NB_SEARCH++;
  
   for (unitclause_position = 0;
        unitclause_position != MY_UNITCLAUSE_STACK_fill_pointer;
        unitclause_position++) {
       unitclause = MY_UNITCLAUSE_STACK[unitclause_position];
       clause_length[unitclause]++;
          lits = sat[unitclause];
          for(lit=*lits; lit!=NONE; lit=*(++lits)) {
              if (positive(lit)) {
                 var = lit;
                 if (var_state[var] == ACTIVE) {
                    var_current_value[var] = TRUE;
                    if (my_manage_clauses(neg_in[var]) == TRUE) {
                       var_state[var] = PASSIVE;
                       push(var, MY_VARIABLE_STACK);
                       break;
                    }
                    else {
                       for (i= unitclause_position+1; 
                            i<MY_UNITCLAUSE_STACK_fill_pointer;
                            i++)
                           clause_length[MY_UNITCLAUSE_STACK[i]]++;
                       NB_FIXED++;
                       return NONE;
                    }
                 }
              }
              else {
                 var = get_var_from_lit(lit);
                 if (var_state[var] == ACTIVE) {
                    var_current_value[var] = FALSE;
                    if (my_manage_clauses(pos_in[var]) == TRUE) {
                       var_state[var] = PASSIVE;
                       push(var, MY_VARIABLE_STACK);
                       break;
                    }
                    else { 
                       for (i= unitclause_position+1;
                            i<MY_UNITCLAUSE_STACK_fill_pointer;
                            i++)
                           clause_length[MY_UNITCLAUSE_STACK[i]]++;
                       NB_FIXED++;
                       return NONE;
                    }
                 }
              }
             
          }
    }
   return TRUE;
}

int get_neg_clause_nb(int var) {
    my_type neg_clause3_nb = 0, neg_clause2_nb = 0;
    int *clauses, clause;
    clauses = neg_in[var];

    for(clause=*clauses; clause!=NONE; clause=*(++clauses)) {

/*    for (index = 0, end_value = neg_nb[var]; index<end_value; index++) {
       clause = clauses[index];
*/
       if (clause_state[clause] == ACTIVE) {
            if (clause_length[clause] == 2)
                neg_clause2_nb++;
            else
                neg_clause3_nb++;
        }
    }
    nb_neg_clause_of_length2[var] = neg_clause2_nb;
    nb_neg_clause_of_length3[var] = neg_clause3_nb;
    return neg_clause2_nb + neg_clause3_nb;
}

int get_pos_clause_nb(int var) {

    my_type pos_clause3_nb = 0, pos_clause2_nb = 0;
    int *clauses, clause;
    clauses = pos_in[var];

    for(clause=*clauses; clause!=NONE; clause=*(++clauses)) {

/*    for (index=0, end_value=pos_nb[var]; index<end_value; index++) {
        clause = clauses[index]; */

        if (clause_state[clause] == ACTIVE) {
            if (clause_length[clause] == 2)
                pos_clause2_nb++;
            else
                pos_clause3_nb++;
        }
    }
    nb_pos_clause_of_length2[var] = pos_clause2_nb;
    nb_pos_clause_of_length3[var] = pos_clause3_nb;
    return pos_clause2_nb + pos_clause3_nb;
}

int choose_and_instantiate_variable_in_clause() {
    int var, chosen_var=NONE; 
    int  i, j, posi, nega;
    int nb_clauses, max_nb_clauses = -1; 
    my_type pos2, neg2;
    long saved_nb_back;
    
    NB_BRANCHE++;
    TESTED_VAR_STACK_fill_pointer=0;

    for (var = 0; var < NB_VAR; var++) {
       if (var_state[var] == ACTIVE) {
           reduce_if_negative_nb[var]=0;
           reduce_if_positive_nb[var]=0;

           if (get_neg_clause_nb(var) == 0) {
	       NB_MONO++;
               var_current_value[var] = TRUE;
               var_rest_value[var] = NONE;
               var_state[var] = PASSIVE;
               push(var, VARIABLE_STACK);
               remove_clauses(pos_in[var]);
           }
           else
           if (get_pos_clause_nb(var) == 0) {
               NB_MONO++;
               var_current_value[var] = FALSE;
               var_rest_value[var] = NONE;
               var_state[var] = PASSIVE;
               push(var, VARIABLE_STACK);
               remove_clauses(neg_in[var]);
           }
           else {
              pos2 = nb_pos_clause_of_length2[var];
              neg2 = nb_neg_clause_of_length2[var];
              if ((neg2>0) && (pos2>0) && ((neg2+pos2)>3) ) {
                 if (examine(var) == NONE) {
                    saved_nb_back = NB_BACK;
                    unitclause_process();
                    if (NB_BACK > saved_nb_back) return NONE;
                 }
              }
           }
       }
    }

   if (TESTED_VAR_STACK_fill_pointer < T) {
   /*   TESTED_VAR_STACK_fill_pointer = 0; */
      for (var=0; var<NB_VAR; var++)
         if (var_state[var] == ACTIVE) {
            pos2 = nb_pos_clause_of_length2[var];
            neg2 = nb_neg_clause_of_length2[var];
            if ((neg2>0) && (pos2 > 0) &&
                ((neg2 > 1) || (pos2 > 1) ) )
               if (reduce_if_negative_nb[var]==0)
	          if (examine(var) == NONE) {
                     saved_nb_back = NB_BACK;
                     unitclause_process();
                     if (NB_BACK > saved_nb_back) return NONE;
                  }
         }
   }

   if (TESTED_VAR_STACK_fill_pointer < T) {
      TESTED_VAR_STACK_fill_pointer = 0;
      for (var=0; var<NB_VAR; var++)
         if (var_state[var] == ACTIVE)
	     if (examine1(var) == NONE) {
                saved_nb_back = NB_BACK;
                unitclause_process();
                if (NB_BACK > saved_nb_back) return NONE;
             }
   }
   for (i=0; i<TESTED_VAR_STACK_fill_pointer; i++) {
       var=TESTED_VAR_STACK[i];
       if (var_state[var] == ACTIVE) {
           posi=reduce_if_positive_nb[var];
           nega=reduce_if_negative_nb[var];
        nb_clauses = posi*nega*1024 + posi + nega +1;
         if (nb_clauses > max_nb_clauses) {
            chosen_var = var;
            max_nb_clauses = nb_clauses;
         }
 
       }
   } 
   if (chosen_var == NONE) return NONE;
   var_state[chosen_var] = PASSIVE;
   saved_clause_stack[chosen_var] = CLAUSE_STACK_fill_pointer;
   saved_managedclause_stack[chosen_var] = MANAGEDCLAUSE_STACK_fill_pointer;
   push(chosen_var, VARIABLE_STACK);
   var_current_value[chosen_var] = TRUE;
   var_rest_value[chosen_var] = FALSE;
   simple_manage_clauses(neg_in[chosen_var]);
   remove_clauses(pos_in[chosen_var]);
}

my_type build(int argc, char *argv[]) {
    if (argc ==3) {
       if ((argv[2][0] == '-') && (argv[2][1] == 's'))
          return build_simple_sat_instance(argv[1]);
       else if ((argv[1][0] == '-') && (argv[1][1] == 's'))
               return build_simple_sat_instance(argv[2]);
       else if (argv[1][0] == '-') 
              return build_sat_instance(argv[2]);
       else return build_sat_instance(argv[1]);
    }
    else return build_sat_instance(argv[1]);
}

main(int argc, char *argv[]) {
   char input_file[WORD_LENGTH], saved_input_file[WORD_LENGTH];
   clock_t begintime, endtime;
   int i,  begin, end, mess; 
   struct tms *a_tms;
   FILE *fp_time;

   if (argc<2) {
      printf("Using format: satz input_instance [-s]\n");
      return;
   }
/*   printf("Enter input file: "); scanf("%s", input_file); */
   for (i=0; i<WORD_LENGTH; i++) saved_input_file[i]=argv[1][i];

 /*  begintime = clock();
*/

   a_tms = ( struct tms *) malloc( sizeof (struct tms));

   mess=times(a_tms); begintime = a_tms->tms_utime;


   switch (build(argc, argv)) {
      case FALSE: printf("Input file error\n"); return;
      case TRUE:
         do {
          if (UNITCLAUSE_STACK_fill_pointer==0)
            choose_and_instantiate_variable_in_clause();
            unitclause_process(); 
         }  while ((VARIABLE_STACK_fill_pointer != 0) && (!(satisfiable())));
         break;
      case NONE: printf("An empty resolvant is found!\n"); break;
   }
/*   endtime=clock();
*/

   mess=times(a_tms); endtime = a_tms->tms_utime;


   if (satisfiable()) {
     printf ("****the instance is satisfiable *****\n");
     if (verify_solution()) {
        printf ("****verification of solution is OK****\n");
        print_values(NB_VAR, saved_input_file);
     }
     else
        printf ("****I'm sorry, your program is wrong****\n");
   }
  else {
     printf ("****the instance is unsatisfiable *****\n");
  }
  printf("NB_MONO= %ld, NB_UNIT= %ld, NB_BRANCHE= %ld, NB_BACK= %ld \n", 
         NB_MONO, NB_UNIT, NB_BRANCHE, NB_BACK);
	        
  printf ("Program terminated in %5.3f seconds.\n",
          ((double)(endtime-begintime)/CLK_TCK));

  fp_time = fopen("timetable", "a");
  fprintf(fp_time, "satz41 %s %5.3f %ld %ld %ld %ld %d %d %d %d\n", 
          saved_input_file, ((double)(endtime-begintime)/CLK_TCK), 
          NB_BRANCHE, NB_BACK,  NB_SEARCH, NB_FIXED, 
          satisfiable(), NB_VAR, INIT_NB_CLAUSE, NB_CLAUSE-INIT_NB_CLAUSE);
  printf("satz41 %s %5.3f %ld %ld %ld %ld %d %d %d %d\n", 
          saved_input_file, ((double)(endtime-begintime)/CLK_TCK), 
          NB_BRANCHE, NB_BACK,  NB_SEARCH, NB_FIXED, 
          satisfiable(), NB_VAR, INIT_NB_CLAUSE, NB_CLAUSE-INIT_NB_CLAUSE);
  fclose(fp_time);

}
 


