/////////////////
// OS Includes
#include <stdio.h>
#include <stdlib.h>
#include <fstream.h>
#include <iostream.h>

//////////////
// Includes
#include "ClauseList.h"
#include "Clause.h"
#include "Random.h"
#include "SATSolver.h"
#include "SATInstance.h"
 
/////////////
// Defines

main(int iArgc_, char* aArgv_[])
{


  if (iArgc_ !=3 && iArgc_ != 4) {
    cout << "======= k-SAT Solver with Lookback Enhancements (Beta) ========" << endl;
    cout << "First argument: <integer> learn order" << endl;
    cout << "Second argumnt: <path name> problem instance (DIMACS format)" << endl;
    cout << "(optional) Third argument: <integer> random number seed" << endl;
    exit(1);
  }
  cout << "Instance is: " << aArgv_[2] << endl; 
  if (iArgc_ == 4) {
    unsigned long lSeed;
    sscanf(aArgv_[3], "%ld", &lSeed);
    Random::vInitRandom(lSeed);    
    cout << "Random number seed: " << lSeed << endl;
  }
  else {
    cout << "Random number seed: 0\n";
    Random::vInitRandom(0);
  }

  int iLearnOrder, iBackjumpOrder;
  sscanf(aArgv_[1], "%d", &iLearnOrder);
  if (iLearnOrder < 0)
    main(0, aArgv_);
  cout << "Learn order is: " << iLearnOrder << endl; 

  boolean bFailed;
  int iFailedCount = 0;
  int iNumTrials = 100;
  unsigned long lBranchTotal = 0;

  for (int i=0; i<iNumTrials; i++) {
    //    cout << "Trail # " << i<< endl;
    SATInstance::xSATInstance.vDestroy();
    if (!SATInstance::xSATInstance.bReadDimacs(aArgv_[2]))
      exit(3);
    SATSolver xSATSolver;
    boolean bSolution = xSATSolver.bFindSolution(iLearnOrder, bFailed);
    if (bFailed) {
      cout << "TIME LIMIT EXPIRED" << endl;
      iFailedCount++;
    }
    else {
      if (bSolution)
	cout << "SAT\n";
      else cout << "UNSAT\n";
    }
    cout << "Branch Points Explored: " << xSATSolver.lBranchPointsExplored() << endl;
    cout << "Variables Labelled    : " << xSATSolver.lVariablesLabelled() << endl;
    cout << "Elapsed Time (cpu sec): " << ((double)xSATSolver.lElapsedTime())/100.0 << endl;
  }
  cout << "Failed count: " << iFailedCount << " / " << iNumTrials << endl;
}


