#ifndef getopt_h
#define getopt_h
/*
  This is the public-domain AT&T getopt(3) code with some simple hacks.
  I include it because many compilers don't support getopt(), e.g. Micosoft visual C++.
*/

#include <string.h>
#include <stdio.h>
#ifndef NULL
#define NULL    0
#endif
#ifndef EOF
#define EOF     (-1)
#endif

#define ERR(s, c)       if(opterr){\
        char errbuf[2];\
        errbuf[0] = c; errbuf[1] = '\n';\
        cout << argv[0];\
        cout << s;\
	cout << errbuf;}


int     opterr = 1;
int     optind = 1;
int     optopt;
char    *optarg;

int
getopt(int argc, char** argv, char* opts)
{
  static int sp = 1;
  register int c;
        register char *cp;

        if(sp == 1)
                if(optind >= argc ||
                   argv[optind][0] != '-' || argv[optind][1] == '\0')
                        return(EOF);
                else if(strcmp(argv[optind], "--") == NULL) {
                        optind++;
                        return(EOF);
                }
        optopt = c = argv[optind][sp];
        if(c == ':' || (cp=strchr(opts, c)) == NULL) {
                ERR(": illegal option -- ", c);
                if(argv[optind][++sp] == '\0') {
                        optind++;
                        sp = 1;
                }
                return('?');
        }
        if(*++cp == ':') {
                if(argv[optind][sp+1] != '\0')
                        optarg = &argv[optind++][sp+1];
                else if(++optind >= argc) {
                        ERR(": option requires an argument -- ", c);
                        sp = 1;
                        return('?');
                } else
                        optarg = argv[optind++];
                sp = 1;
        } else {
                if(argv[optind][++sp] == '\0') {
                        sp = 1;
                        optind++;
                }
                optarg = NULL;
        }
        return(c);
}

#endif //getopt_h
